/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.entities;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Entity {
    private static final Logger logger = LoggerFactory.getLogger(Entity.class);

    public <T extends Entity> void set(T other) {
        for (Method method : other.getClass().getMethods()) {
            Method setter;
            if (!method.getName().startsWith("get")) continue;
            try {
                setter = this.getClass().getMethod(method.getName().replace("get", "set"), method.getReturnType());
            }
            catch (NoSuchMethodException e) {
                logger.trace("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043c\u0435\u0442\u043e\u0434 " + method.getName().replace("get", "set") + ". \u041f\u043e\u043b\u0435 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u043e.");
                continue;
            }
            try {
                Object o = method.invoke(other, new Object[0]);
                if (o instanceof Entity) {
                    o = Entity.clone((Entity)o);
                }
                setter.invoke((Object)this, o);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u043e\u043b\u0435\u0439 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438", (Throwable)e);
            }
        }
    }

    public static <T extends Entity> T clone(T original) {
        try {
            Entity clone = (Entity)original.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            clone.set(original);
            return (T)clone;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043b\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438", (Throwable)e);
            return original;
        }
    }
}

