/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.entities;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.Template;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class Publication
extends MetaEntity {
    private Template template;
    private String href;
    private transient PublicationType type;

    public Template getTemplate() {
        return this.template;
    }

    public String getHref() {
        return this.href;
    }

    public PublicationType getType() {
        return this.type;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setType(PublicationType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Publication)) {
            return false;
        }
        Publication other = (Publication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Template this$template = this.getTemplate();
        Template other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        return !(this$href == null ? other$href != null : !this$href.equals(other$href));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Publication;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Template $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        return result;
    }

    public static class Deserializer
    extends JsonDeserializer<Publication> {
        private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

        public Publication deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Publication publication = (Publication)this.objectMapper.treeToValue((TreeNode)node, Publication.class);
            if (publication.getMeta() != null) {
                if (publication.getMeta().getType() == null) {
                    throw new JsonParseException(p, "Can't parse publication: meta.type is null");
                }
                switch (publication.getMeta().getType()) {
                    case CONTRACT_PUBLICATION: {
                        publication.setType(PublicationType.CONTRACT);
                        break;
                    }
                    case OPERATION_PUBLICATION: {
                        publication.setType(PublicationType.OPERATION);
                        break;
                    }
                    default: {
                        throw new JsonParseException(p, "Can't parse publication: meta.type must be one of [\"contractpublication\", \"operationpublication\"]");
                    }
                }
            }
            return publication;
        }
    }

    public static enum PublicationType {
        OPERATION,
        CONTRACT;

    }
}

