/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils;

import java.util.stream.Collectors;
import ru.moysklad.remap_1_2.responses.ErrorResponse;

public class ApiClientException
extends Exception {
    private final int statusCode;
    private final String reasonPhrase;
    private final ErrorResponse errorResponse;

    public ApiClientException(String uri, int statusCode, String reasonPhrase) {
        super(uri + ": " + statusCode + " " + reasonPhrase);
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.errorResponse = null;
    }

    public ApiClientException(String uri, int statusCode, String reasonPhrase, ErrorResponse er) {
        super(er.getErrors().isEmpty() ? statusCode + " " + reasonPhrase : "\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 '" + uri + "' \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 (" + statusCode + " " + reasonPhrase + "):\n" + er.getErrors().stream().map(e -> " - " + e.getCode() + " " + e.getError()).collect(Collectors.joining("\n")));
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.errorResponse = er;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }
}

