/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.agents.Counterparty;
import ru.moysklad.remap_1_2.entities.agents.Employee;
import ru.moysklad.remap_1_2.entities.agents.Organization;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class AgentDeserializer
extends JsonDeserializer<Agent> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public Agent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        MetaEntity me = (MetaEntity)this.objectMapper.treeToValue((TreeNode)node, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException(p, "Can't parse field 'agent': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException(p, "Can't parse field 'agent': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case ORGANIZATION: {
                return (Agent)this.objectMapper.treeToValue((TreeNode)node, Organization.class);
            }
            case COUNTERPARTY: {
                return (Agent)this.objectMapper.treeToValue((TreeNode)node, Counterparty.class);
            }
            case EMPLOYEE: {
                return (Agent)this.objectMapper.treeToValue((TreeNode)node, Employee.class);
            }
        }
        throw new JsonParseException(p, "Can't parse field 'agent': meta.type must be one of [organization, counterparty, employee]");
    }
}

