/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.discounts.AccumulationDiscount;
import ru.moysklad.remap_1_2.entities.discounts.BonusProgram;
import ru.moysklad.remap_1_2.entities.discounts.Discount;
import ru.moysklad.remap_1_2.entities.discounts.PersonalDiscount;
import ru.moysklad.remap_1_2.entities.discounts.RoundOffDiscount;
import ru.moysklad.remap_1_2.entities.discounts.SpecialPriceDiscount;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class DiscountDeserializer
extends JsonDeserializer<Discount> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public Discount deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        MetaEntity me = (MetaEntity)this.objectMapper.treeToValue((TreeNode)node, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException(p, "Can't parse field 'discount': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException(p, "Can't parse field 'discount': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case ACCUMULATION_DISCOUNT: {
                return (Discount)this.objectMapper.treeToValue((TreeNode)node, AccumulationDiscount.class);
            }
            case BONUS_PROGRAM: {
                return (Discount)this.objectMapper.treeToValue((TreeNode)node, BonusProgram.class);
            }
            case DISCOUNT: {
                return (Discount)this.objectMapper.treeToValue((TreeNode)node, Discount.class);
            }
            case PERSONAL_DISCOUNT: {
                return (Discount)this.objectMapper.treeToValue((TreeNode)node, PersonalDiscount.class);
            }
            case SPECIAL_PRICE_DISCOUNT: {
                return (Discount)this.objectMapper.treeToValue((TreeNode)node, SpecialPriceDiscount.class);
            }
            case ROUND_OFF_DISCOUNT: {
                return (Discount)this.objectMapper.treeToValue((TreeNode)node, RoundOffDiscount.class);
            }
        }
        throw new JsonParseException(p, "Can't parse field 'discount': meta.type must be one of [accumulationdiscount, bonusprogram, discount, personaldiscount, specialpricediscount, roundoffdiscount]");
    }
}

