/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import ru.moysklad.remap_1_2.entities.DocumentAttribute;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class DocumentAttributeSerializer
extends JsonSerializer<DocumentAttribute> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public void serialize(DocumentAttribute src, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (src.getType() != null) {
            switch (src.getType()) {
                case timeValue: {
                    if (src.getValue() == null) break;
                    if (src.getValue() instanceof LocalDateTime) {
                        src.setValue(((LocalDateTime)src.getValue()).format(this.formatter));
                        break;
                    }
                    if (src.getValue() instanceof LocalDate) {
                        src.setValue(((LocalDate)src.getValue()).format(this.formatter));
                        break;
                    }
                    throw new IllegalArgumentException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0441 \u0442\u0438\u043f\u043e\u043c 'time': " + src.getValue().getClass().getSimpleName());
                }
            }
            TypeFactory typeFactory = TypeFactory.defaultInstance();
            JavaType javaType = typeFactory.constructType(DocumentAttribute.class);
            BeanSerializerFactory.instance.createSerializer(serializers, javaType).serialize((Object)src, gen, serializers);
        } else if (src.getEntityType() != null) {
            JsonNode node = this.objectMapper.valueToTree((Object)src);
            ObjectNode objectNode = (ObjectNode)node;
            JsonNode entityTypeNode = objectNode.get("entityType");
            objectNode.set("type", entityTypeNode);
            objectNode.remove("entityType");
            ((ObjectMapper)gen.getCodec()).writeTree(gen, node);
        }
    }
}

