/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.moysklad.remap_1_2.entities.Context;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.responses.ListEntity;

public class ListEntityDeserializer
extends JsonDeserializer<ListEntity>
implements ContextualDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(ListEntityDeserializer.class);
    private JavaType type;

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        if (beanProperty != null) {
            JavaType wrapperType = beanProperty.getType();
            JavaType valueType = wrapperType.containedType(0);
            return new ListEntityDeserializer(valueType);
        }
        return this;
    }

    public ListEntity deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ListEntity le;
        block7: {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            le = new ListEntity();
            le.setMeta((Meta)jp.getCodec().treeToValue((TreeNode)node.get("meta"), Meta.class));
            le.setContext((Context)jp.getCodec().treeToValue((TreeNode)node.get("context"), Context.class));
            JsonNode rows = node.get("rows");
            if (rows == null || !rows.isArray()) break block7;
            le.setRows(new ArrayList());
            if (this.type != null) {
                for (JsonNode row : rows) {
                    le.getRows().add(((ObjectMapper)jp.getCodec()).readValue(row.toString(), this.type));
                }
            } else {
                for (JsonNode row : rows) {
                    try {
                        JsonNode metaNode = row.get("meta");
                        String metaType = metaNode != null ? metaNode.get("type").asText() : null;
                        Class<MetaEntity> metaClass = MetaEntity.class;
                        if (metaType != null) {
                            Meta.Type metaEnum = Meta.Type.find(metaType);
                            metaClass = metaEnum.getModelClass();
                        }
                        le.getRows().add(jp.getCodec().treeToValue((TreeNode)row, metaClass));
                    }
                    catch (Exception e) {
                        logger.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 rows", (Throwable)e);
                    }
                }
            }
        }
        return le;
    }

    public ListEntityDeserializer() {
    }

    public ListEntityDeserializer(JavaType type) {
        this.type = type;
    }
}

