/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.Consignment;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.products.Bundle;
import ru.moysklad.remap_1_2.entities.products.Product;
import ru.moysklad.remap_1_2.entities.products.Service;
import ru.moysklad.remap_1_2.entities.products.Variant;
import ru.moysklad.remap_1_2.entities.products.markers.ProductMarker;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class ProductMarkerDeserializer
extends JsonDeserializer<ProductMarker> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public ProductMarker deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        MetaEntity me = (MetaEntity)this.objectMapper.treeToValue((TreeNode)node, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException(p, "Can't parse field 'product': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException(p, "Can't parse field 'product': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case PRODUCT: {
                return (ProductMarker)this.objectMapper.treeToValue((TreeNode)node, Product.class);
            }
            case SERVICE: {
                return (ProductMarker)this.objectMapper.treeToValue((TreeNode)node, Service.class);
            }
            case BUNDLE: {
                return (ProductMarker)this.objectMapper.treeToValue((TreeNode)node, Bundle.class);
            }
            case VARIANT: {
                return (ProductMarker)this.objectMapper.treeToValue((TreeNode)node, Variant.class);
            }
            case CONSIGNMENT: {
                return (ProductMarker)this.objectMapper.treeToValue((TreeNode)node, Consignment.class);
            }
        }
        throw new JsonParseException(p, "Can't parse field 'product': meta.type must be one of [product, service, bundle, variant, consignment]");
    }
}

