/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.params;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import ru.moysklad.remap_1_2.entities.Attribute;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.utils.MetaHrefUtils;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public class FilterParam
extends ApiParam {
    private final Object key;
    private final Object value;
    private final FilterType filterType;
    private final EntityFilterType entityFilterType;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    private FilterParam(String key, FilterType filterType, String value) {
        super(ApiParam.Type.filter);
        this.key = key;
        this.value = value;
        this.filterType = filterType;
        this.entityFilterType = EntityFilterType.SIMPLE;
    }

    private FilterParam(Attribute key, FilterType filterType, Object value) {
        super(ApiParam.Type.filter);
        this.key = key;
        this.value = value;
        this.filterType = filterType;
        this.entityFilterType = EntityFilterType.ATTRIBUTE;
    }

    private FilterParam(String key, FilterType filterType, MetaEntity value) {
        super(ApiParam.Type.filter);
        this.key = key;
        this.value = value;
        this.filterType = filterType;
        this.entityFilterType = EntityFilterType.HREF;
    }

    public static FilterParam filterEq(String key, String value) {
        return FilterParam.filter(key, FilterType.equals, value);
    }

    public static FilterParam filterNot(String key, String value) {
        return FilterParam.filter(key, FilterType.not_equals, value);
    }

    public static FilterParam filter(String key, FilterType filterType, String value) {
        return new FilterParam(key, filterType, value);
    }

    public static FilterParam filterEq(Attribute key, Object value) {
        return FilterParam.filter(key, FilterType.equals, value);
    }

    public static FilterParam filterNot(Attribute key, Object value) {
        return FilterParam.filter(key, FilterType.not_equals, value);
    }

    public static FilterParam filter(Attribute key, FilterType filterType, Object value) {
        return new FilterParam(key, filterType, value);
    }

    public static FilterParam filterEq(String key, MetaEntity value) {
        return FilterParam.filter(key, FilterType.equals, value);
    }

    public static FilterParam filterNot(String key, MetaEntity value) {
        return FilterParam.filter(key, FilterType.not_equals, value);
    }

    public static FilterParam filter(String key, FilterType filterType, MetaEntity value) {
        return new FilterParam(key, filterType, value);
    }

    @Override
    protected String render(String host) {
        StringBuilder filterString = new StringBuilder();
        block0 : switch (this.entityFilterType) {
            case SIMPLE: {
                filterString.append(this.key).append(this.filterType.str).append(this.value);
                break;
            }
            case HREF: {
                MetaEntity hrefValue = (MetaEntity)this.value;
                filterString.append(this.key).append(this.filterType.str);
                if (hrefValue == null) break;
                filterString.append(MetaHrefUtils.makeHref(Meta.Type.find(hrefValue), hrefValue, host));
                break;
            }
            case ATTRIBUTE: {
                Attribute attrKey = (Attribute)this.key;
                if (attrKey == null) {
                    throw new IllegalArgumentException("key \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
                }
                if (attrKey.getMeta() == null || attrKey.getMeta().getHref() == null) {
                    if (attrKey.getAttributeEntityType() == null) {
                        throw new IllegalArgumentException("key.attributeEntityType \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
                    }
                    if (attrKey.getId() == null) {
                        throw new IllegalArgumentException("key.id \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
                    }
                    filterString.append(host).append("/entity/").append(attrKey.getAttributeEntityType().getApiName()).append("/metadata/attributes/").append(attrKey.getId()).append(this.filterType.str);
                } else {
                    filterString.append(attrKey.getMeta().getHref());
                }
                switch (attrKey.getType()) {
                    case stringValue: 
                    case longValue: 
                    case doubleValue: 
                    case fileValue: 
                    case booleanValue: 
                    case textValue: 
                    case linkValue: {
                        filterString.append(this.value.toString());
                        break block0;
                    }
                    case timeValue: {
                        filterString.append(formatter.format((LocalDateTime)this.value));
                        break block0;
                    }
                }
                if (this.value == null) break;
                if (MetaEntity.class.isAssignableFrom(this.value.getClass())) {
                    Meta.Type type = attrKey.getEntityType();
                    type = type == null ? Meta.Type.find((MetaEntity)this.value) : type;
                    filterString.append(MetaHrefUtils.makeHref(type, (MetaEntity)this.value, host));
                    break;
                }
                throw new IllegalArgumentException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f: " + this.value.getClass().getSimpleName());
            }
        }
        return filterString.toString();
    }

    public static enum FilterType {
        equals("="),
        greater(">"),
        lesser("<"),
        greater_or_equals(">="),
        lesser_or_equals("<="),
        not_equals("!="),
        equivalence("~"),
        equivalence_left("~="),
        equivalence_right("=~");

        private final String str;

        private FilterType(String str) {
            this.str = str;
        }

        public String getStr() {
            return this.str;
        }
    }

    private static enum EntityFilterType {
        SIMPLE,
        HREF,
        ATTRIBUTE;

    }
}

