/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients;

import java.io.IOException;
import ru.moysklad.remap_1_2.ApiClient;
import ru.moysklad.remap_1_2.clients.EntityClientBase;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.DeleteByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetListEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.HasFilesEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.HasImagesEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MassCreateUpdateDeleteEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PostEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.ProductMetadataAttributeEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.ProductMetadataEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PutByIdEndpoint;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.products.Bundle;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.responses.metadata.MetadataAttributeSharedPriceTypesResponse;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public final class BundleClient
extends EntityClientBase
implements GetListEndpoint<Bundle>,
PostEndpoint<Bundle>,
GetByIdEndpoint<Bundle>,
PutByIdEndpoint<Bundle>,
ProductMetadataEndpoint,
ProductMetadataAttributeEndpoint,
MassCreateUpdateDeleteEndpoint<Bundle>,
DeleteByIdEndpoint,
HasImagesEndpoint<Bundle>,
HasFilesEndpoint<Bundle> {
    public BundleClient(ApiClient api) {
        super(api, "/entity/bundle/");
    }

    @Override
    public Class<? extends MetaEntity> entityClass() {
        return Bundle.class;
    }

    @Override
    public Class<? extends MetaEntity> metaEntityClass() {
        return MetadataAttributeSharedPriceTypesResponse.class;
    }

    @ApiEndpoint
    public ListEntity<Bundle.ComponentEntity> getComponents(String bundleId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + bundleId + "/components").apiParams(params).list(Bundle.ComponentEntity.class);
    }

    @ApiEndpoint
    public ListEntity<Bundle.ComponentEntity> getComponents(Bundle bundle, ApiParam ... params) throws IOException, ApiClientException {
        return this.getComponents(bundle.getId(), params);
    }

    @ApiEndpoint
    public Bundle.ComponentEntity getComponent(String bundleId, String componentId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + bundleId + "/components/" + componentId).apiParams(params).get(Bundle.ComponentEntity.class);
    }

    @ApiEndpoint
    public Bundle.ComponentEntity getComponent(Bundle bundle, String componentId, ApiParam ... params) throws IOException, ApiClientException {
        return this.getComponent(bundle.getId(), componentId, params);
    }

    @ApiEndpoint
    public Bundle.ComponentEntity getComponent(Bundle bundle, Bundle.ComponentEntity component, ApiParam ... params) throws IOException, ApiClientException {
        return this.getComponent(bundle, component.getId(), params);
    }

    @ApiEndpoint
    public void deleteComponent(String bundleId, String componentId) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + bundleId + "/components/" + componentId).delete();
    }

    @ApiEndpoint
    public void deleteComponent(Bundle entity, String componentId) throws IOException, ApiClientException {
        this.deleteComponent(entity.getId(), componentId);
    }

    @ApiEndpoint
    public void deleteComponent(Bundle entity, Bundle.ComponentEntity component) throws IOException, ApiClientException {
        this.deleteComponent(entity, component.getId());
    }
}

