/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import ru.moysklad.remap_1_2.entities.Contract;
import ru.moysklad.remap_1_2.entities.CustomEntityElement;
import ru.moysklad.remap_1_2.entities.DocumentAttribute;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.Project;
import ru.moysklad.remap_1_2.entities.Store;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.products.markers.ProductAttributeMarker;
import ru.moysklad.remap_1_2.utils.MetaHrefUtils;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class DocumentAttributeDeserializer
extends JsonDeserializer<DocumentAttribute> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public DocumentAttribute deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (!node.has("type")) {
            throw new IllegalArgumentException("\u0412 \u043f\u0440\u0438\u0448\u0435\u0434\u0448\u0435\u0439 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u043d\u0435\u0442 \u043f\u043e\u043b\u044f 'type'!");
        }
        String attrType = node.get("type").asText();
        try {
            Meta.Type t = Meta.Type.find(attrType);
            ((ObjectNode)node).remove("type");
            ((ObjectNode)node).put("entityType", t.getApiName());
        }
        catch (IllegalArgumentException t) {
            // empty catch block
        }
        DocumentAttribute ae = (DocumentAttribute)this.objectMapper.treeToValue((TreeNode)node, DocumentAttribute.class);
        if (ae.getType() != null && ae.getValue() != null) {
            switch (ae.getType()) {
                case longValue: {
                    ae.setValue(((Integer)ae.getValue()).longValue());
                    break;
                }
                case timeValue: {
                    ae.setValue(LocalDateTime.parse(String.valueOf(ae.getValue()), this.formatter));
                }
            }
        } else if (ae.getEntityType() != null) {
            switch (ae.getEntityType()) {
                case COUNTERPARTY: 
                case ORGANIZATION: 
                case EMPLOYEE: {
                    ae.setValue(p.getCodec().treeToValue((TreeNode)node.get("value"), Agent.class));
                    break;
                }
                case PRODUCT: 
                case BUNDLE: 
                case SERVICE: {
                    ae.setValue(p.getCodec().treeToValue((TreeNode)node.get("value"), ProductAttributeMarker.class));
                    break;
                }
                case CONTRACT: {
                    ae.setValue(p.getCodec().treeToValue((TreeNode)node.get("value"), Contract.class));
                    break;
                }
                case PROJECT: {
                    ae.setValue(p.getCodec().treeToValue((TreeNode)node.get("value"), Project.class));
                    break;
                }
                case STORE: {
                    ae.setValue(p.getCodec().treeToValue((TreeNode)node.get("value"), Store.class));
                    break;
                }
                case CUSTOM_ENTITY: {
                    CustomEntityElement customEntity = (CustomEntityElement)p.getCodec().treeToValue((TreeNode)node.get("value"), CustomEntityElement.class);
                    if (customEntity != null) {
                        customEntity.setCustomDictionaryId(MetaHrefUtils.getCustomDictionaryIdFromHref(customEntity.getMeta().getHref()));
                    }
                    ae.setValue(customEntity);
                }
            }
        }
        return ae;
    }
}

