/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.notifications.Notification;
import ru.moysklad.remap_1_2.entities.notifications.NotificationCustomerOrder;
import ru.moysklad.remap_1_2.entities.notifications.NotificationExchange;
import ru.moysklad.remap_1_2.entities.notifications.NotificationGoodCountTooLow;
import ru.moysklad.remap_1_2.entities.notifications.NotificationInvoiceOutOverdue;
import ru.moysklad.remap_1_2.entities.notifications.NotificationRetailShift;
import ru.moysklad.remap_1_2.entities.notifications.NotificationRetailShiftClosed;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscribeExpired;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscribeTermsExpired;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTask;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTaskChanged;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTaskComment;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class NotificationDeserializer
extends JsonDeserializer<Notification> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public Notification deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        MetaEntity me = (MetaEntity)this.objectMapper.treeToValue((TreeNode)node, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException(p, "Can't parse notification: meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException(p, "Can't parse notification: meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case NOTIFICATION_ORDER_NEW: 
            case NOTIFICATION_ORDER_OVERDUE: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationCustomerOrder.class);
            }
            case NOTIFICATION_INVOICE_OUT_OVERDUE: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationInvoiceOutOverdue.class);
            }
            case NOTIFICATION_GOOD_COUNT_TOO_LOW: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationGoodCountTooLow.class);
            }
            case NOTIFICATION_TASK_ASSIGNED: 
            case NOTIFICATION_TASK_UNASSIGNED: 
            case NOTIFICATION_TASK_OVERDUE: 
            case NOTIFICATION_TASK_COMPLETED: 
            case NOTIFICATION_TASK_REOPENED: 
            case NOTIFICATION_TASK_DELETED: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationTask.class);
            }
            case NOTIFICATION_TASK_CHANGED: 
            case NOTIFICATION_TASK_COMMENT_CHANGED: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationTaskChanged.class);
            }
            case NOTIFICATION_TASK_COMMENT_DELETED: 
            case NOTIFICATION_TASK_NEW_COMMENT: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationTaskComment.class);
            }
            case NOTIFICATION_IMPORT_COMPLETED: 
            case NOTIFICATION_EXPORT_COMPLETED: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationExchange.class);
            }
            case NOTIFICATION_SUBSCRIBE_EXPIRED: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationSubscribeExpired.class);
            }
            case NOTIFICATION_SUBSCRIBE_TERMS_EXPIRED: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationSubscribeTermsExpired.class);
            }
            case NOTIFICATION_RETAIL_SHIFT_OPENED: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationRetailShift.class);
            }
            case NOTIFICATION_RETAIL_SHIFT_CLOSED: {
                return (Notification)p.getCodec().treeToValue((TreeNode)node, NotificationRetailShiftClosed.class);
            }
        }
        throw new JsonParseException(p, "Can't parse notification: meta.type must be one of \"Notification*\"");
    }
}

