/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.ProductFolder;
import ru.moysklad.remap_1_2.entities.products.Bundle;
import ru.moysklad.remap_1_2.entities.products.Product;
import ru.moysklad.remap_1_2.entities.products.Service;
import ru.moysklad.remap_1_2.entities.products.Variant;
import ru.moysklad.remap_1_2.entities.products.markers.ProductAttributeMarker;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class ProductAttributeMarkerDeserializer
extends JsonDeserializer<ProductAttributeMarker> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public ProductAttributeMarker deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        MetaEntity me = (MetaEntity)this.objectMapper.treeToValue((TreeNode)node, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException(p, "Can't parse field 'product': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException(p, "Can't parse field 'product': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case PRODUCT_FOLDER: {
                return (ProductAttributeMarker)this.objectMapper.treeToValue((TreeNode)node, ProductFolder.class);
            }
            case PRODUCT: {
                return (ProductAttributeMarker)this.objectMapper.treeToValue((TreeNode)node, Product.class);
            }
            case SERVICE: {
                return (ProductAttributeMarker)this.objectMapper.treeToValue((TreeNode)node, Service.class);
            }
            case BUNDLE: {
                return (ProductAttributeMarker)this.objectMapper.treeToValue((TreeNode)node, Bundle.class);
            }
            case VARIANT: {
                return (ProductAttributeMarker)this.objectMapper.treeToValue((TreeNode)node, Variant.class);
            }
        }
        throw new JsonParseException(p, "Can't parse field 'product': meta.type must be one of [product, service, bundle, variant, consignment, productfolder]");
    }
}

