/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.products.Product;
import ru.moysklad.remap_1_2.entities.products.Service;
import ru.moysklad.remap_1_2.entities.products.Variant;
import ru.moysklad.remap_1_2.entities.products.markers.SingleProductMarker;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class SingleProductMarkerDeserializer
extends JsonDeserializer<SingleProductMarker> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public SingleProductMarker deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        MetaEntity me = (MetaEntity)this.objectMapper.treeToValue((TreeNode)node, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException(p, "Can't parse field 'product': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException(p, "Can't parse field 'product': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case PRODUCT: {
                return (SingleProductMarker)p.getCodec().treeToValue((TreeNode)node, Product.class);
            }
            case SERVICE: {
                return (SingleProductMarker)p.getCodec().treeToValue((TreeNode)node, Service.class);
            }
            case VARIANT: {
                return (SingleProductMarker)p.getCodec().treeToValue((TreeNode)node, Variant.class);
            }
        }
        throw new JsonParseException(p, "Can't parse field 'product': meta.type must be one of [product, service, bundle, variant, consignment]");
    }
}

