/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import org.apache.spark.Logging;
import org.apache.spark.ml.odkl.FoldedFeatureSelector;
import org.apache.spark.ml.odkl.FoldedFeatureSelector$;
import org.apache.spark.ml.odkl.HasWeights;
import org.apache.spark.ml.odkl.LinearModel;
import org.apache.spark.ml.odkl.ModelSummary;
import org.apache.spark.ml.odkl.ModelWithSummary;
import org.apache.spark.ml.odkl.SummarizableEstimator;
import org.apache.spark.ml.odkl.UnwrappedStage$;
import org.apache.spark.ml.odkl.WeightsStatRecord;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.odkl.SparkSqlUtils$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;

public final class FoldedFeatureSelector$
implements Serializable,
Logging {
    public static final FoldedFeatureSelector$ MODULE$;
    private final String WEIGHTS_STAT;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new FoldedFeatureSelector$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String WEIGHTS_STAT() {
        return this.WEIGHTS_STAT;
    }

    public Option<Vector> tryGetInitials(StructField field) {
        None$ none$;
        if (field.metadata() != null && field.metadata().contains(this.WEIGHTS_STAT())) {
            WeightsStatRecord[] stat = (WeightsStatRecord[])Predef$.MODULE$.refArrayOps((Object[])field.metadata().getMetadataArray(this.WEIGHTS_STAT())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final WeightsStatRecord apply(Metadata x) {
                    return new WeightsStatRecord(x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeightsStatRecord.class)));
            Vector dense = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stat).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(WeightsStatRecord x$4) {
                    return x$4.isRelevant();
                }
            })).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(WeightsStatRecord x$5) {
                    return x$5.index();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(WeightsStatRecord x$6) {
                    return x$6.average();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            this.logInfo((Function0<String>)new Serializable(field, dense){
                public static final long serialVersionUID = 0L;
                private final StructField field$2;
                private final Vector dense$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got initial weights for field ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$2.name(), this.dense$1}));
                }
                {
                    this.field$2 = field$2;
                    this.dense$1 = dense$1;
                }
            });
            none$ = new Some((Object)dense);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <M extends LinearModel<M>> M transformLinearModel(int originalSize, int[] relevant, M model) {
        ModelSummary nestedSummary = model.summary();
        SparseVector coefficients = new SparseVector(originalSize, relevant, model.getCoefficients().toArray());
        Object object = SparkSqlUtils$.MODULE$.reflectionLock();
        synchronized (object) {
            ModelSummary modelSummary = nestedSummary.transform((Tuple2<ModelWithSummary.Block, Function1<DataFrame, DataFrame>>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)model.weights()), (Object)new Serializable(relevant, model){
                public static final long serialVersionUID = 0L;
                public final int[] relevant$3;
                private final LinearModel model$1;

                public final DataFrame apply(DataFrame data) {
                    UserDefinedFunction reindex = functions$.MODULE$.udf((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.13 $outer;

                        public final int apply(int i) {
                            return this.apply$mcII$sp(i);
                        }

                        public int apply$mcII$sp(int i) {
                            return i >= 0 ? this.$outer.relevant$3[i] : i;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
                    return data.withColumn(this.model$1.index(), reindex.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{data.apply(this.model$1.index())})));
                }
                {
                    this.relevant$3 = relevant$3;
                    this.model$1 = model$1;
                }
            }), (Seq<Tuple2<ModelWithSummary.Block, Function1<DataFrame, DataFrame>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : object
            ModelSummary summary = modelSummary;
            return (M)((LinearModel)model.copy(summary, ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{model.coefficients().$minus$greater((Object)coefficients)}))));
        }
    }

    public <SelectingModel extends ModelWithSummary<SelectingModel> & HasWeights, ResultModel extends LinearModel<ResultModel>> SummarizableEstimator<ResultModel> select(SummarizableEstimator<SelectingModel> selector, SummarizableEstimator<ResultModel> estimator, double minSignificance, String featuresCol) {
        FoldedFeatureSelector.LinearModelFoldedFeatureSelector significanceSelector = (FoldedFeatureSelector.LinearModelFoldedFeatureSelector)new FoldedFeatureSelector.LinearModelFoldedFeatureSelector(selector).setMinSignificance(minSignificance);
        significanceSelector.set(significanceSelector.featuresCol().$minus$greater((Object)featuresCol));
        return UnwrappedStage$.MODULE$.wrap(estimator, significanceSelector);
    }

    public <SelectingModel extends ModelWithSummary<SelectingModel> & HasWeights, ResultModel extends LinearModel<ResultModel>> String select$default$4() {
        return "features";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FoldedFeatureSelector$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.WEIGHTS_STAT = "features_stat";
    }
}

