/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl.texts;

import java.util.Random;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.odkl.texts.RandomProjectionsHasher$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.IndexedSeqView$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001=\u0011qCU1oI>l\u0007K]8kK\u000e$\u0018n\u001c8t\u0011\u0006\u001c\b.\u001a:\u000b\u0005\r!\u0011!\u0002;fqR\u001c(BA\u0003\u0007\u0003\u0011yGm\u001b7\u000b\u0005\u001dA\u0011AA7m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!Bd\b\t\u0003#Ii\u0011AB\u0005\u0003'\u0019\u00111\u0002\u0016:b]N4wN]7feB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0007g\"\f'/\u001a3\u000b\u0005e1\u0011!\u00029be\u0006l\u0017BA\u000e\u0017\u0005-A\u0015m]%oaV$8i\u001c7\u0011\u0005Ui\u0012B\u0001\u0010\u0017\u00051A\u0015m](viB,HoQ8m!\t)\u0002%\u0003\u0002\"-\t9\u0001*Y:TK\u0016$\u0007\u0002C\u0012\u0001\u0005\u000b\u0007I\u0011\t\u0013\u0002\u0007ULG-F\u0001&!\t1CF\u0004\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003&\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016)\u0011!\u0001\u0004A!A!\u0002\u0013)\u0013\u0001B;jI\u0002BQA\r\u0001\u0005\u0002M\na\u0001P5oSRtDC\u0001\u001b7!\t)\u0004!D\u0001\u0003\u0011\u0015\u0019\u0013\u00071\u0001&\u0011\u001dA\u0004A1A\u0005\u0002e\n\u0011BY1tSN\u001c\u0016N_3\u0016\u0003i\u0002\"a\u000f\u001f\u000e\u0003aI!!\u0010\r\u0003\u00131{gn\u001a)be\u0006l\u0007BB \u0001A\u0003%!(\u0001\u0006cCNL7oU5{K\u0002Bq!\u0011\u0001C\u0002\u0013\u0005\u0011(A\u0002eS6Daa\u0011\u0001!\u0002\u0013Q\u0014\u0001\u00023j[\u0002Bq!\u0012\u0001C\u0002\u0013\u0005a)\u0001\u0005ta\u0006\u00148/\u001b;z+\u00059\u0005CA\u001eI\u0013\tI\u0005DA\u0006E_V\u0014G.\u001a)be\u0006l\u0007BB&\u0001A\u0003%q)A\u0005ta\u0006\u00148/\u001b;zA!)Q\n\u0001C\u0001\u001d\u0006Yq-\u001a;Ta\u0006\u00148/\u001b;z+\u0005y\u0005CA\u0014Q\u0013\t\t\u0006F\u0001\u0004E_V\u0014G.\u001a\u0005\u0006'\u0002!\t\u0001V\u0001\rO\u0016$()Y:jgNK'0Z\u000b\u0002+B\u0011qEV\u0005\u0003/\"\u0012A\u0001T8oO\")\u0011\f\u0001C\u0001)\u00061q-\u001a;ES6DQa\u0017\u0001\u0005\u0002q\u000b1b]3u\u0013:\u0004X\u000f^\"pYR\u0011QLX\u0007\u0002\u0001!)qL\u0017a\u0001K\u0005)a/\u00197vK\")\u0011\r\u0001C\u0001E\u0006Y1/\u001a;Ta\u0006\u00148/\u001b;z)\ti6\rC\u0003`A\u0002\u0007q\nC\u0003f\u0001\u0011\u0005a-\u0001\u0007tKR|U\u000f\u001e9vi\u000e{G\u000e\u0006\u0002^O\")q\f\u001aa\u0001K!)\u0011\u000e\u0001C\u0001U\u0006a1/\u001a;CCNL7oU5{KR\u0011Ql\u001b\u0005\u0006?\"\u0004\r!\u0016\u0005\u0006[\u0002!\tA\\\u0001\u0007g\u0016$H)[7\u0015\u0005u{\u0007\"B0m\u0001\u0004)\u0006\"\u0002\u001a\u0001\t\u0003\tH#\u0001\u001b\t\u000bM\u0004A\u0011\t;\u0002\u0013Q\u0014\u0018M\\:g_JlGCA;|!\t1\u00180D\u0001x\u0015\tA\b\"A\u0002tc2L!A_<\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"\u0002?s\u0001\u0004)\u0018a\u00023bi\u0006\u001cX\r\u001e\u0005\u0006}\u0002!\te`\u0001\u0005G>\u0004\u0018\u0010F\u0002\u0011\u0003\u0003Aq!a\u0001~\u0001\u0004\t)!A\u0003fqR\u0014\u0018\rE\u0002<\u0003\u000fI1!!\u0003\u0019\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bbBA\u0007\u0001\u0011\u0005\u0013qB\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011\u0011CA\u000f!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\fo\u0006)A/\u001f9fg&!\u00111DA\u000b\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0003?\tY\u00011\u0001\u0002\u0012\u000511o\u00195f[\u0006DC!a\u0003\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*!\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti#a\n\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public class RandomProjectionsHasher
extends Transformer
implements HasInputCol,
HasOutputCol,
HasSeed {
    private final String uid;
    private final LongParam basisSize;
    private final LongParam dim;
    private final DoubleParam sparsity;
    private final LongParam seed;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public final LongParam seed() {
        return this.seed;
    }

    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    public final long getSeed() {
        return HasSeed.class.getSeed((HasSeed)this);
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    public final String getOutputCol() {
        return HasOutputCol.class.getOutputCol((HasOutputCol)this);
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    public final String getInputCol() {
        return HasInputCol.class.getInputCol((HasInputCol)this);
    }

    public String uid() {
        return this.uid;
    }

    public LongParam basisSize() {
        return this.basisSize;
    }

    public LongParam dim() {
        return this.dim;
    }

    public DoubleParam sparsity() {
        return this.sparsity;
    }

    public double getSparsity() {
        return BoxesRunTime.unboxToDouble((Object)this.$((Param)this.sparsity()));
    }

    public long getBasisSize() {
        return BoxesRunTime.unboxToLong((Object)this.$((Param)this.basisSize()));
    }

    public long getDim() {
        return BoxesRunTime.unboxToLong((Object)this.$((Param)this.dim()));
    }

    public RandomProjectionsHasher setInputCol(String value) {
        return (RandomProjectionsHasher)this.set(this.inputCol(), value);
    }

    public RandomProjectionsHasher setSparsity(double value) {
        return (RandomProjectionsHasher)this.set((Param)this.sparsity(), BoxesRunTime.boxToDouble((double)value));
    }

    public RandomProjectionsHasher setOutputCol(String value) {
        return (RandomProjectionsHasher)this.set(this.outputCol(), value);
    }

    public RandomProjectionsHasher setBasisSize(long value) {
        return (RandomProjectionsHasher)this.set((Param)this.basisSize(), BoxesRunTime.boxToLong((long)value));
    }

    public RandomProjectionsHasher setDim(long value) {
        return (RandomProjectionsHasher)this.set((Param)this.dim(), BoxesRunTime.boxToLong((long)value));
    }

    public DataFrame transform(DataFrame dataset) {
        int n;
        if (this.isSet((Param)this.dim())) {
            n = (int)BoxesRunTime.unboxToLong((Object)this.$((Param)this.dim()));
        } else {
            int vectorsIndex = dataset.schema().fieldIndex((String)this.$(this.inputCol()));
            n = AttributeGroup$.MODULE$.fromStructField(dataset.schema().fields()[vectorsIndex]).size();
        }
        int dimensity = n;
        Broadcast projectionMatrix = dataset.sqlContext().sparkContext().broadcast((Object)((SparseMatrix)Matrices$.MODULE$.sprandn((int)BoxesRunTime.unboxToLong((Object)this.$((Param)this.basisSize())), dimensity, BoxesRunTime.unboxToDouble((Object)this.$((Param)this.sparsity())), new Random(BoxesRunTime.unboxToLong((Object)this.$((Param)this.seed()))))), ClassTag$.MODULE$.apply(SparseMatrix.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomProjectionsHasher.class.getClassLoader());
        public final class Org_apache_spark_ml_odkl_texts_RandomProjectionsHasher$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_odkl_texts_RandomProjectionsHasher$$typecreator1$1(RandomProjectionsHasher $outer) {
            }
        }
        UserDefinedFunction binHashSparseVectorColumn = functions$.MODULE$.udf((Function1)new Serializable(this, projectionMatrix){
            public static final long serialVersionUID = 0L;
            private final Broadcast projectionMatrix$1;

            public final long apply(Vector vector) {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.doubleArrayOps(((Matrix)this.projectionMatrix$1.value()).multiply(vector).values()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(double f) {
                        return this.apply$mcJD$sp(f);
                    }

                    public long apply$mcJD$sp(double f) {
                        return f > 0.0 ? 1L : 0L;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x0$1, Tuple2<Object, Object> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), x1$1);
                        if (tuple2 != null) {
                            long acc = tuple2._1$mcJ$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                long v = tuple22._1$mcJ$sp();
                                int i = tuple22._2$mcI$sp();
                                long l = acc | v << i;
                                return l;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }));
            }
            {
                this.projectionMatrix$1 = projectionMatrix$1;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_odkl_texts_RandomProjectionsHasher$$typecreator1$1(this)));
        return dataset.withColumn((String)this.$(this.outputCol()), binHashSparseVectorColumn.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.col((String)this.$(this.inputCol()))})));
    }

    public Transformer copy(ParamMap extra) {
        return (Transformer)this.defaultCopy(extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return SchemaUtils$.MODULE$.appendColumn(schema, (String)this.$(this.outputCol()), (DataType)LongType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public RandomProjectionsHasher(String uid) {
        this.uid = uid;
        HasInputCol.class.$init$((HasInputCol)this);
        HasOutputCol.class.$init$((HasOutputCol)this);
        HasSeed.class.$init$((HasSeed)this);
        this.basisSize = new LongParam((Identifiable)this, "basisSize", "number of random vector-normales e.g. 2 ^ binsNum buckets", ParamValidators$.MODULE$.gt(0.0));
        this.dim = new LongParam((Identifiable)this, "dim", "dimension of sparse vectors e.g. Bag-Of-Word vocab size");
        this.sparsity = new DoubleParam((Identifiable)this, "sparsity", "sparsity param in mllib.linal.Matrices.sparndn", ParamValidators$.MODULE$.inRange(0.0, 1.0, false, true));
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{new ParamPair((Param)this.basisSize(), (Object)BoxesRunTime.boxToLong((long)18L)), new ParamPair((Param)this.sparsity(), (Object)BoxesRunTime.boxToDouble((double)0.5))}));
    }

    public RandomProjectionsHasher() {
        this(Identifiable$.MODULE$.randomUID("randomProjectionsHasher"));
    }
}

