/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.odkl.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.odkl.SparkSqlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001b\ti\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\u0004\t\u0005!q\u000eZ6m\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0011%5\t!!\u0003\u0002\u0012\u0005\tIQI^1mk\u0006$xN\u001d\t\u0003\u001f\u0001AQ\u0001\u0006\u0001\u0005\u0002U\ta\u0001P5oSRtD#\u0001\n\t\u000f]\u0001!\u0019!C\u00031\u00059a.^7CS:\u001cX#A\r\u0011\u0007iir$D\u0001\u001c\u0015\taB!A\u0003qCJ\fW.\u0003\u0002\u001f7\t)\u0001+\u0019:b[B\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t\u0019\u0011J\u001c;\t\r\u0019\u0002\u0001\u0015!\u0004\u001a\u0003!qW/\u001c\"j]N\u0004\u0003\"\u0002\u0015\u0001\t\u0003J\u0013!\u0003;sC:\u001chm\u001c:n)\tQ\u0003\u0007\u0005\u0002,]5\tAF\u0003\u0002.\r\u0005\u00191/\u001d7\n\u0005=b#!\u0003#bi\u00064%/Y7f\u0011\u0015\tt\u00051\u0001+\u0003\u001d!\u0017\r^1tKRDQa\r\u0001\u0005BQ\nAaY8qsR\u0011!#\u000e\u0005\u0006mI\u0002\raN\u0001\u0006Kb$(/\u0019\t\u00035aJ!!O\u000e\u0003\u0011A\u000b'/Y7NCBDQa\u000f\u0001\u0005Bq\nq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0003{\r\u0003\"AP!\u000e\u0003}R!\u0001\u0011\u0017\u0002\u000bQL\b/Z:\n\u0005\t{$AC*ueV\u001cG\u000fV=qK\")AI\u000fa\u0001{\u000511o\u00195f[\u0006D#A\u000f$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%3\u0011AC1o]>$\u0018\r^5p]&\u00111\n\u0013\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public class BinaryClassificationEvaluator
extends Evaluator<BinaryClassificationEvaluator> {
    private final Param<Object> numBins = new Param((Identifiable)this, "numBins", "How many points to add to nested curves (recall/precision or roc)");

    public final Param<Object> numBins() {
        return this.numBins;
    }

    public DataFrame transform(DataFrame dataset) {
        RDD predictions = dataset.select((String)this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.labelCol())})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object score = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (score instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)score);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictions, 100);
        RDD rows = metrics.roc().count() > 2L ? dataset.sqlContext().sparkContext().parallelize((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"auc", BoxesRunTime.boxToDouble((double)metrics.areaUnderROC()), null, null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"au_pr", BoxesRunTime.boxToDouble((double)metrics.areaUnderPR()), null, null}))}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])metrics.fMeasureByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"f1", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class)).union(metrics.fMeasureByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"f1", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.precisionByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.recallByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"recall", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.pr().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "recall", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.roc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tp_rate", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "fp_rate", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).collect()), Seq$.MODULE$.canBuildFrom()), 1, ClassTag$.MODULE$.apply(Seq.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Seq<Object> x) {
                return Row$.MODULE$.fromSeq(x);
            }
        }, ClassTag$.MODULE$.apply(Row.class)) : dataset.sqlContext().sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(Row.class));
        metrics.unpersist();
        Object object = SparkSqlUtils$.MODULE$.reflectionLock();
        synchronized (object) {
            DataFrame dataFrame = dataset.sqlContext().createDataFrame(rows, this.transformSchema(dataset.schema()));
            return dataFrame;
        }
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.copyValues((Params)new BinaryClassificationEvaluator(), extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return new StructType().add("metric", (DataType)StringType$.MODULE$, false).add("value", (DataType)DoubleType$.MODULE$, false).add("x-metric", (DataType)StringType$.MODULE$, true).add("x-value", (DataType)DoubleType$.MODULE$, true);
    }

    public BinaryClassificationEvaluator() {
        this.setDefault(this.numBins(), BoxesRunTime.boxToInteger((int)100));
    }
}

