/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.odkl;

import java.io.Serializable;
import org.apache.spark.Logging;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\t\u0011\u0012j]8u_:L7MU3he\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\u0003pI.d'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!B\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t!![8\u000b\u0003e\tAA[1wC&\u00111D\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003;yi\u0011AB\u0005\u0003?\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\"\u0001\t\u0005\r\u0011\"\u0003#\u0003!I7o\u001c;p]&\u001cW#A\u0012\u0011\u0005=!\u0013BA\u0013\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001b\n\u0001\u0003\u0002\u0004%I\u0001K\u0001\rSN|Go\u001c8jG~#S-\u001d\u000b\u0003S1\u0002\"a\u0004\u0016\n\u0005-\u0002\"\u0001B+oSRDq!\f\u0014\u0002\u0002\u0003\u00071%A\u0002yIEB\u0001b\f\u0001\u0003\u0002\u0003\u0006KaI\u0001\nSN|Go\u001c8jG\u0002BQ!\r\u0001\u0005\nI\na\u0001P5oSRtDCA\u001a6!\t!\u0004!D\u0001\u0003\u0011\u0015\t\u0003\u00071\u0001$\u0011\u0015\t\u0004\u0001\"\u00018)\u0005\u0019\u0004f\u0001\u001c:\u007fA\u0011!(P\u0007\u0002w)\u0011AHB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001 <\u0005\u0015\u0019\u0016N\\2fC\u0005\u0001\u0015!B\u0019/g9\u0002\u0004\"\u0002\"\u0001\t\u0003\u0019\u0015aC:fi&\u001bx\u000e^8oS\u000e$\"\u0001R#\u000e\u0003\u0001AQ!I!A\u0002\rB3!Q\u001d@\u0011\u0015A\u0005\u0001\"\u0001J\u0003\r\u0011XO\u001c\u000b\u0003\u0015B\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002P\u0019\n9\u0012j]8u_:L7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0005\u0006#\u001e\u0003\rAU\u0001\u0006S:\u0004X\u000f\u001e\t\u0004'ZCV\"\u0001+\u000b\u0005U3\u0011a\u0001:eI&\u0011q\u000b\u0016\u0002\u0004%\u0012#\u0005#B\bZ7n[\u0016B\u0001.\u0011\u0005\u0019!V\u000f\u001d7fgA\u0011q\u0002X\u0005\u0003;B\u0011a\u0001R8vE2,\u0007fA$:\u007f!)\u0001\n\u0001C\u0001AR\u0011!*\u0019\u0005\u0006#~\u0003\rA\u0019\t\u0004G\u001eLW\"\u00013\u000b\u0005e)'B\u00014\u0007\u0003\r\t\u0007/[\u0005\u0003Q\u0012\u0014qAS1wCJ#E\tE\u0003\u00103*T'\u000e\u0005\u0002l]6\tAN\u0003\u0002n1\u0005!A.\u00198h\u0013\tiF\u000eK\u0002`s}BQ!\u001d\u0001\u0005\nI\fQ\u0003]8pY\u0006#'.Y2f]R4\u0016n\u001c7bi>\u00148\u000f\u0006\u0002tmB\u0019q\u0002\u001e-\n\u0005U\u0004\"!B!se\u0006L\b\"B)q\u0001\u0004\u0019\b\"\u0002=\u0001\t\u0013I\u0018!\b9be\u0006dG.\u001a7Q_>d\u0017\t\u001a6bG\u0016tGOV5pY\u0006$xN]:\u0015\u0005MT\b\"B)x\u0001\u0004\u0011\u0006f\u0001\u0001:\u007f\u0001")
public class IsotonicRegression
implements Serializable,
Logging {
    private boolean isotonic;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private boolean isotonic() {
        return this.isotonic;
    }

    private void isotonic_$eq(boolean x$1) {
        this.isotonic = x$1;
    }

    public IsotonicRegression setIsotonic(boolean isotonic) {
        this.isotonic_$eq(isotonic);
        return this;
    }

    public IsotonicRegressionModel run(RDD<Tuple3<Object, Object, Object>> input) {
        RDD preprocessedInput = this.isotonic() ? input : input.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)(-BoxesRunTime.unboxToDouble((Object)x._1()))), x._2(), x._3());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        Tuple3<Object, Object, Object>[] pooled = this.parallelPoolAdjacentViolators(preprocessedInput);
        double[] predictions = this.isotonic() ? (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$1) {
                return BoxesRunTime.unboxToDouble((Object)x$1._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$2) {
                return -BoxesRunTime.unboxToDouble((Object)x$2._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] boundaries = (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$3) {
                return BoxesRunTime.unboxToDouble((Object)x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        if (Predef$.MODULE$.double2Double(predictions[0]).isNaN()) {
            this.logWarning((Function0<String>)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Got NaN at the beginning of the predictions, replacing with 0.0";
                }
            });
            predictions[0] = 0.0;
        }
        if (Predef$.MODULE$.double2Double(boundaries[0]).isNaN()) {
            this.logWarning((Function0<String>)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Got NaN at the beginning of the boundaries, replacing with 0.0";
                }
            });
            boundaries[0] = 0.0;
        }
        return new IsotonicRegressionModel(boundaries, predictions, this.isotonic());
    }

    public IsotonicRegressionModel run(JavaRDD<Tuple3<Double, Double, Double>> input) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)input.rdd().retag(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$mllib$odkl$IsotonicRegression$$poolAdjacentViolators(Tuple3<Object, Object, Object>[] input) {
        if (Predef$.MODULE$.refArrayOps((Object[])input).isEmpty()) {
            return (Tuple3[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        int i = 0;
        int len = input.length;
        while (i < len) {
            int j;
            for (j = i; j < len - 1 && BoxesRunTime.unboxToDouble((Object)input[j]._1()) > BoxesRunTime.unboxToDouble((Object)input[j + 1]._1()); ++j) {
            }
            if (i == j) {
                ++i;
                continue;
            }
            while (i >= 0 && BoxesRunTime.unboxToDouble((Object)input[i]._1()) > BoxesRunTime.unboxToDouble((Object)input[i + 1]._1())) {
                this.pool$1(input, i, j);
                --i;
            }
            i = j;
        }
        ArrayBuffer compressed = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple3 tuple3 = (Tuple3)Predef$.MODULE$.refArrayOps((Object[])input).head();
        if (tuple3 != null) {
            Tuple3 tuple32;
            double curLabel = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double curFeature = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double curWeight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel), (Object)BoxesRunTime.boxToDouble((double)curFeature), (Object)BoxesRunTime.boxToDouble((double)curWeight));
            DoubleRef curLabel2 = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)tuple33._1()));
            DoubleRef curFeature2 = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)tuple33._2()));
            DoubleRef curWeight2 = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)tuple33._3()));
            DoubleRef rightBound = DoubleRef.create((double)curFeature2.elem);
            for (i = 1; i < input.length; ++i) {
                Tuple3<Object, Object, Object> tuple34 = input[i];
                if (tuple34 != null) {
                    Tuple3 tuple35;
                    double label = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                    double feature = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                    double weight = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                    Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)weight));
                    double label2 = BoxesRunTime.unboxToDouble((Object)tuple36._1());
                    double feature2 = BoxesRunTime.unboxToDouble((Object)tuple36._2());
                    double weight2 = BoxesRunTime.unboxToDouble((Object)tuple36._3());
                    if (label2 == curLabel2.elem) {
                        curWeight2.elem += weight2;
                        rightBound.elem = feature2;
                        continue;
                    }
                    this.merge$1(compressed, curLabel2, curFeature2, curWeight2, rightBound);
                    curLabel2.elem = label2;
                    curFeature2.elem = feature2;
                    curWeight2.elem = weight2;
                    rightBound.elem = curFeature2.elem;
                    continue;
                }
                throw new MatchError(tuple34);
            }
            this.merge$1(compressed, curLabel2, curFeature2, curWeight2, rightBound);
            return (Tuple3[])compressed.toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        throw new MatchError((Object)tuple3);
    }

    private Tuple3<Object, Object, Object>[] parallelPoolAdjacentViolators(RDD<Tuple3<Object, Object, Object>> input) {
        Tuple3[] parallelStepResult = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])input.glom().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegression $outer;

            public final ArrayOps<Tuple3<Object, Object, Object>> apply(Tuple3<Object, Object, Object>[] arr) {
                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$odkl$IsotonicRegression$$poolAdjacentViolators((Tuple3[])Predef$.MODULE$.refArrayOps((Object[])arr).sortBy((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                        return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
                    }
                }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect()).sortBy((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$));
        return this.org$apache$spark$mllib$odkl$IsotonicRegression$$poolAdjacentViolators(parallelStepResult);
    }

    private final void pool$1(Tuple3[] input, int start, int end) {
        DoubleRef weightedSum = DoubleRef.create((double)0.0);
        DoubleRef weight = DoubleRef.create((double)0.0);
        Predef$.MODULE$.refArrayOps((Object[])input).view().slice(start, end + 1).foreach((Function1)new scala.Serializable(this, weightedSum, weight){
            public static final long serialVersionUID = 0L;
            private final DoubleRef weightedSum$1;
            private final DoubleRef weight$1;

            public final void apply(Tuple3<Object, Object, Object> x) {
                this.weightedSum$1.elem += BoxesRunTime.unboxToDouble((Object)x._1()) * BoxesRunTime.unboxToDouble((Object)x._3());
                this.weight$1.elem += BoxesRunTime.unboxToDouble((Object)x._3());
            }
            {
                this.weightedSum$1 = weightedSum$1;
                this.weight$1 = weight$1;
            }
        });
        double update2 = weight.elem != 0.0 ? weightedSum.elem / weight.elem : 0.0;
        for (int i = start; i <= end; ++i) {
            input[i] = new Tuple3((Object)BoxesRunTime.boxToDouble((double)update2), input[i]._2(), input[i]._3());
        }
    }

    private final void merge$1(ArrayBuffer compressed$1, DoubleRef curLabel$1, DoubleRef curFeature$1, DoubleRef curWeight$1, DoubleRef rightBound$1) {
        compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)curFeature$1.elem), (Object)BoxesRunTime.boxToDouble((double)curWeight$1.elem)));
        if (rightBound$1.elem > curFeature$1.elem) {
            compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)rightBound$1.elem), (Object)BoxesRunTime.boxToDouble((double)0.0)));
        }
    }

    private IsotonicRegression(boolean isotonic) {
        this.isotonic = isotonic;
        Logging.class.$init$((Logging)this);
    }

    public IsotonicRegression() {
        this(true);
    }
}

