/*
 * Decompiled with CFR 0.152.
 */
package odkl.analysis.spark.util;

import odkl.analysis.spark.util.SQLOperations;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public abstract class SQLOperations$class {
    public static UserDefinedAggregateFunction collectAsList(SQLOperations $this, DataType dataType) {
        DataType dataType2 = dataType;
        SQLOperations.CollectAsList collectAsList = IntegerType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsList(dataType, ClassTag$.MODULE$.Int()) : (LongType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsList(dataType, ClassTag$.MODULE$.Long()) : (FloatType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsList(dataType, ClassTag$.MODULE$.Float()) : (DoubleType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsList(dataType, ClassTag$.MODULE$.Double()) : (StringType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsList(dataType, ClassTag$.MODULE$.apply(String.class)) : new SQLOperations.CollectAsList(dataType, ClassTag$.MODULE$.Any())))));
        return collectAsList;
    }

    public static UserDefinedAggregateFunction collectAsSet(SQLOperations $this, DataType dataType) {
        DataType dataType2 = dataType;
        SQLOperations.CollectAsList collectAsList = IntegerType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsSet(dataType, ClassTag$.MODULE$.Int(), Ordering.Int$.MODULE$) : (LongType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsSet(dataType, ClassTag$.MODULE$.Long(), Ordering.Long$.MODULE$) : (FloatType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsSet(dataType, ClassTag$.MODULE$.Float(), Ordering.Float$.MODULE$) : (DoubleType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsSet(dataType, ClassTag$.MODULE$.Double(), Ordering.Double$.MODULE$) : (StringType$.MODULE$.equals(dataType2) ? new SQLOperations.CollectAsSet(dataType, ClassTag$.MODULE$.apply(String.class), Ordering.String$.MODULE$) : new SQLOperations.CollectAsList(dataType, ClassTag$.MODULE$.Any())))));
        return collectAsList;
    }

    public static UserDefinedFunction willsonLower(SQLOperations $this, SQLContext sqlContext, double confidence, double minBound) {
        if (confidence <= 0.0 || confidence >= 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_CONFIDENCE_LEVEL, (Number)Predef$.MODULE$.double2Double(confidence), (Number)Predef$.MODULE$.int2Integer(0), (Number)Predef$.MODULE$.int2Integer(1));
        }
        double alpha = (1.0 - confidence) / (double)2;
        NormalDistribution normalDistribution = new NormalDistribution();
        double z = normalDistribution.inverseCumulativeProbability(1.0 - alpha);
        double zSquared = FastMath.pow((double)z, (int)2);
        return sqlContext.udf().register(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wilsonLowerBound_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Math.round(confidence * (double)100))})), (Function2)new Serializable($this, z, zSquared, minBound){
            public static final long serialVersionUID = 0L;
            private final double z$1;
            private final double zSquared$1;
            private final double minBound$1;

            public final double apply(long positive, long total) {
                return this.apply$mcDJJ$sp(positive, total);
            }

            public double apply$mcDJJ$sp(long positive, long total) {
                double d;
                if (total <= 0L) {
                    throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, (Number)Predef$.MODULE$.long2Long(total));
                }
                if (positive < 0L) {
                    throw new NotPositiveException((Localizable)LocalizedFormats.NEGATIVE_NUMBER_OF_SUCCESSES, (Number)Predef$.MODULE$.long2Long(positive));
                }
                if (positive > total) {
                    throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, (Number)Predef$.MODULE$.long2Long(positive), (Number)Predef$.MODULE$.long2Long(total), true);
                }
                if (total <= 0L) {
                    d = 0.0;
                } else {
                    double mean = (double)positive / (double)total;
                    double factor = 1.0 / (1.0 + 1.0 / (double)total * this.zSquared$1);
                    double modifiedSuccessRatio = mean + 1.0 / (double)(2L * total) * this.zSquared$1;
                    double difference = this.z$1 * FastMath.sqrt((double)(1.0 / (double)total * mean * (1.0 - mean) + 1.0 / ((double)4 * FastMath.pow((double)total, (int)2)) * this.zSquared$1));
                    d = factor * (modifiedSuccessRatio - difference);
                }
                double result = d;
                return result < this.minBound$1 ? 0.0 : result;
            }
            {
                this.z$1 = z$1;
                this.zSquared$1 = zSquared$1;
                this.minBound$1 = minBound$1;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
    }

    public static double willsonLower$default$2(SQLOperations $this) {
        return 0.95;
    }

    public static double willsonLower$default$3(SQLOperations $this) {
        return 0.0;
    }

    public static void $init$(SQLOperations $this) {
    }
}

