/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.odkl.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.odkl.SparkSqlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001b\ti\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\u0004\t\u0005!q\u000eZ6m\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0011%5\t!!\u0003\u0002\u0012\u0005\tIQI^1mk\u0006$xN\u001d\t\u0003\u001f\u0001AQ\u0001\u0006\u0001\u0005\u0002U\ta\u0001P5oSRtD#\u0001\n\t\u000f]\u0001!\u0019!C\u00031\u00059a.^7CS:\u001cX#A\r\u0011\u0007iir$D\u0001\u001c\u0015\taB!A\u0003qCJ\fW.\u0003\u0002\u001f7\t)\u0001+\u0019:b[B\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t\u0019\u0011J\u001c;\t\r\u0019\u0002\u0001\u0015!\u0004\u001a\u0003!qW/\u001c\"j]N\u0004\u0003\"\u0002\u0015\u0001\t\u0003J\u0013!\u0003;sC:\u001chm\u001c:n)\tQc\b\u0005\u0002,w9\u0011A\u0006\u000f\b\u0003[Yr!AL\u001b\u000f\u0005=\"dB\u0001\u00194\u001b\u0005\t$B\u0001\u001a\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003o\u0019\t1a]9m\u0013\tI$(A\u0004qC\u000e\\\u0017mZ3\u000b\u0005]2\u0011B\u0001\u001f>\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002:u!)qh\na\u0001\u0001\u00069A-\u0019;bg\u0016$\bGA!H!\r\u00115)R\u0007\u0002u%\u0011AI\u000f\u0002\b\t\u0006$\u0018m]3u!\t1u\t\u0004\u0001\u0005\u0013!s\u0014\u0011!A\u0001\u0006\u0003I%aA0%cE\u0011!*\u0014\t\u0003A-K!\u0001T\u0011\u0003\u000f9{G\u000f[5oOB\u0011\u0001ET\u0005\u0003\u001f\u0006\u00121!\u00118z\u0011\u0015\t\u0006\u0001\"\u0011S\u0003\u0011\u0019w\u000e]=\u0015\u0005I\u0019\u0006\"\u0002+Q\u0001\u0004)\u0016!B3yiJ\f\u0007C\u0001\u000eW\u0013\t96D\u0001\u0005QCJ\fW.T1q\u0011\u0015I\u0006\u0001\"\u0011[\u0003=!(/\u00198tM>\u0014XnU2iK6\fGCA.b!\tav,D\u0001^\u0015\tq&(A\u0003usB,7/\u0003\u0002a;\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\tD\u0006\u0019A.\u0002\rM\u001c\u0007.Z7bQ\tAF\r\u0005\u0002fQ6\taM\u0003\u0002h\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005%4'\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007")
public class BinaryClassificationEvaluator
extends Evaluator<BinaryClassificationEvaluator> {
    private final Param<Object> numBins = new Param((Identifiable)this, "numBins", "How many points to add to nested curves (recall/precision or roc)");

    public final Param<Object> numBins() {
        return this.numBins;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        RDD predictions = dataset.select((String)this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.labelCol())})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object score = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (score instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)score);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictions, 100);
        RDD rows = metrics.roc().count() > 2L ? dataset.sqlContext().sparkContext().parallelize((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"auc", BoxesRunTime.boxToDouble((double)metrics.areaUnderROC()), null, null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"au_pr", BoxesRunTime.boxToDouble((double)metrics.areaUnderPR()), null, null}))}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])metrics.fMeasureByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"f1", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class)).union(metrics.fMeasureByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"f1", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.precisionByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.recallByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"recall", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.pr().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "recall", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.roc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tp_rate", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "fp_rate", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).collect()), Seq$.MODULE$.canBuildFrom()), 1, ClassTag$.MODULE$.apply(Seq.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Seq<Object> x) {
                return Row$.MODULE$.fromSeq(x);
            }
        }, ClassTag$.MODULE$.apply(Row.class)) : dataset.sqlContext().sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(Row.class));
        metrics.unpersist();
        Object object = SparkSqlUtils$.MODULE$.reflectionLock();
        synchronized (object) {
            Dataset dataset2 = dataset.sqlContext().createDataFrame(rows, this.transformSchema(dataset.schema()));
            return dataset2;
        }
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.copyValues((Params)new BinaryClassificationEvaluator(), extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return new StructType().add("metric", (DataType)StringType$.MODULE$, false).add("value", (DataType)DoubleType$.MODULE$, false).add("x-metric", (DataType)StringType$.MODULE$, true).add("x-value", (DataType)DoubleType$.MODULE$, true);
    }

    public BinaryClassificationEvaluator() {
        this.setDefault(this.numBins(), BoxesRunTime.boxToInteger((int)100));
    }
}

