/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.odkl.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.odkl.SparkSqlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001b\ti\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\u0004\t\u0005!q\u000eZ6m\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0011%5\t!!\u0003\u0002\u0012\u0005\tIQI^1mk\u0006$xN\u001d\t\u0003\u001f\u0001A\u0001\u0002\u0006\u0001\u0003\u0006\u0004%\t%F\u0001\u0004k&$W#\u0001\f\u0011\u0005]ibB\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001f?\t11\u000b\u001e:j]\u001eT!\u0001H\r\t\u0013\u0005\u0002!\u0011!Q\u0001\nY\u0011\u0013\u0001B;jI\u0002J!\u0001\u0006\t\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t\u0011b\u0005C\u0003\u0015G\u0001\u0007a\u0003C\u0003%\u0001\u0011\u0005\u0001\u0006F\u0001\u0013\u0011\u001dQ\u0003A1A\u0005\u0006-\nqA\\;n\u0005&t7/F\u0001-!\ri\u0003GM\u0007\u0002])\u0011q\u0006B\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003c9\u0012Q\u0001U1sC6\u0004\"\u0001G\u001a\n\u0005QJ\"aA%oi\"1a\u0007\u0001Q\u0001\u000e1\n\u0001B\\;n\u0005&t7\u000f\t\u0005\u0006q\u0001!\t%O\u0001\niJ\fgn\u001d4pe6$\"A\u000f(\u0011\u0005mZeB\u0001\u001fI\u001d\tidI\u0004\u0002?\u000b:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u00052\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t9e!A\u0002tc2L!!\u0013&\u0002\u000fA\f7m[1hK*\u0011qIB\u0005\u0003\u00196\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005%S\u0005\"B(8\u0001\u0004\u0001\u0016a\u00023bi\u0006\u001cX\r\u001e\u0019\u0003#^\u00032AU*V\u001b\u0005Q\u0015B\u0001+K\u0005\u001d!\u0015\r^1tKR\u0004\"AV,\r\u0001\u0011I\u0001LTA\u0001\u0002\u0003\u0015\t!\u0017\u0002\u0004?\u0012\n\u0014C\u0001.^!\tA2,\u0003\u0002]3\t9aj\u001c;iS:<\u0007C\u0001\r_\u0013\ty\u0016DA\u0002B]fDQ!\u0019\u0001\u0005B\t\fAaY8qsR\u0011!c\u0019\u0005\u0006I\u0002\u0004\r!Z\u0001\u0006Kb$(/\u0019\t\u0003[\u0019L!a\u001a\u0018\u0003\u0011A\u000b'/Y7NCBDQ!\u001b\u0001\u0005B)\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0003WF\u0004\"\u0001\\8\u000e\u00035T!A\u001c&\u0002\u000bQL\b/Z:\n\u0005Al'AC*ueV\u001cG\u000fV=qK\")!\u000f\u001ba\u0001W\u000611o\u00195f[\u0006D#\u0001\u001b;\u0011\u0005UDX\"\u0001<\u000b\u0005]4\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011P\u001e\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public class BinaryClassificationEvaluator
extends Evaluator<BinaryClassificationEvaluator> {
    private final Param<Object> numBins = new Param((Identifiable)this, "numBins", "How many points to add to nested curves (recall/precision or roc)");

    @Override
    public String uid() {
        return super.uid();
    }

    public final Param<Object> numBins() {
        return this.numBins;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        RDD predictions = dataset.select((String)this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.labelCol())})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object score = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (score instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)score);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictions, 100);
        RDD rows = metrics.roc().count() > 2L ? dataset.sqlContext().sparkContext().parallelize((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"auc", BoxesRunTime.boxToDouble((double)metrics.areaUnderROC()), null, null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"au_pr", BoxesRunTime.boxToDouble((double)metrics.areaUnderPR()), null, null}))}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])metrics.fMeasureByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"f1", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class)).union(metrics.fMeasureByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"f1", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.precisionByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.recallByThreshold().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"recall", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "threshold", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.pr().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"precision", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "recall", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).union(metrics.roc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, Object> x) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tp_rate", BoxesRunTime.boxToDouble((double)x._2$mcD$sp()), "fp_rate", BoxesRunTime.boxToDouble((double)x._1$mcD$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class))).collect()), Seq$.MODULE$.canBuildFrom()), 1, ClassTag$.MODULE$.apply(Seq.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Seq<Object> x) {
                return Row$.MODULE$.fromSeq(x);
            }
        }, ClassTag$.MODULE$.apply(Row.class)) : dataset.sqlContext().sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(Row.class));
        metrics.unpersist();
        Object object = SparkSqlUtils$.MODULE$.reflectionLock();
        synchronized (object) {
            Dataset dataset2 = dataset.sqlContext().createDataFrame(rows, this.transformSchema(dataset.schema()));
            return dataset2;
        }
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.copyValues((Params)new BinaryClassificationEvaluator(), extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return new StructType().add("metric", (DataType)StringType$.MODULE$, false).add("value", (DataType)DoubleType$.MODULE$, false).add("x-metric", (DataType)StringType$.MODULE$, true).add("x-value", (DataType)DoubleType$.MODULE$, true);
    }

    public BinaryClassificationEvaluator(String uid) {
        super(uid);
        this.setDefault(this.numBins(), BoxesRunTime.boxToInteger((int)100));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binaryClassificationEvaluator"));
    }
}

