/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import odkl.analysis.spark.util.RDDOperations$;
import odkl.analysis.spark.util.collection.CompactBuffer;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.odkl.CRRSamplerParams;
import org.apache.spark.ml.odkl.CRRSamplerParams$class;
import org.apache.spark.ml.odkl.HasGroupByColumns;
import org.apache.spark.ml.odkl.HasGroupByColumns$class;
import org.apache.spark.ml.odkl.HasNetlibBlas;
import org.apache.spark.ml.odkl.HasNetlibBlas$class;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u00015\u0011qb\u0011*S'\u0006l\u0007\u000f\\3s\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tAa\u001c3lY*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002\u0006\u000e\u001e!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'\u0001i\u0011A\u0001\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tA!\u001e;jY&\u0011\u0011D\u0006\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:Xe&$\u0018M\u00197f!\t\u00192$\u0003\u0002\u001d\u0005\t\u00012I\u0015*TC6\u0004H.\u001a:QCJ\fWn\u001d\t\u0003'yI!a\b\u0002\u0003\u001b!\u000b7OT3uY&\u0014'\t\\1t\u0011!\t\u0003A!b\u0001\n\u0003\u0012\u0013aA;jIV\t1\u0005\u0005\u0002%U9\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003$\u0003\u0011)\u0018\u000e\u001a\u0011\t\u000bA\u0002A\u0011A\u0019\u0002\rqJg.\u001b;?)\t\u0011\"\u0007C\u0003\"_\u0001\u00071\u0005C\u00031\u0001\u0011\u0005A\u0007F\u0001\u0013\u0011\u00151\u0004\u0001\"\u00118\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u00029\u0019B\u0011\u0011(\u0013\b\u0003u\u0019s!a\u000f#\u000f\u0005q\u001aeBA\u001fC\u001d\tq\u0014)D\u0001@\u0015\t\u0001E\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0012\u0004\u0002\u0007M\fH.\u0003\u0002H\u0011\u00069\u0001/Y2lC\u001e,'BA#\u0007\u0013\tQ5JA\u0005ECR\fgI]1nK*\u0011q\t\u0013\u0005\u0006\u001bV\u0002\rAT\u0001\bI\u0006$\u0018m]3ua\tyU\u000bE\u0002Q#Nk\u0011\u0001S\u0005\u0003%\"\u0013q\u0001R1uCN,G\u000f\u0005\u0002U+2\u0001A!\u0003,M\u0003\u0003\u0005\tQ!\u0001X\u0005\ryF%M\t\u00031n\u0003\"!J-\n\u0005i3#a\u0002(pi\"Lgn\u001a\t\u0003KqK!!\u0018\u0014\u0003\u0007\u0005s\u0017\u0010C\u0003`\u0001\u0011\u0005\u0001-\u0001\u0006tC6\u0004H.\u001a*poN$B!\u00197ogB\u0019!MZ5\u000f\u0005\r,gB\u0001 e\u0013\u00059\u0013BA$'\u0013\t9\u0007N\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t9e\u0005\u0005\u0002QU&\u00111\u000e\u0013\u0002\u0004%><\b\"B7_\u0001\u0004\t\u0017\u0001\u0002:poNDQa\u001c0A\u0002A\f!\u0002\\1cK2Le\u000eZ3y!\t)\u0013/\u0003\u0002sM\t\u0019\u0011J\u001c;\t\u000bQt\u0006\u0019\u00019\u0002\u0019\u0019,\u0017\r^;sK&sG-\u001a=\t\u000bY\u0004A\u0011A<\u0002\u001b\r|WO\u001c;feN\u000bW\u000e\u001d7f)\u0011\t\u0007P_@\t\u000be,\b\u0019A1\u0002\rM|WO]2f\u0011\u0015YX\u000f1\u0001}\u0003-\u0019w.\u001e8uKJ\u0004\u0016M\u001d;\u0011\u0007\tl\u0018.\u0003\u0002\u007fQ\n\u00191+Z9\t\u000bQ,\b\u0019\u00019\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005Q\u0001/Y5s'\u0006l\u0007\u000f\\3\u0015\u000f%\f9!a\u0003\u0002\u000e!9\u0011\u0011BA\u0001\u0001\u0004I\u0017AB:b[BdW\r\u0003\u0004|\u0003\u0003\u0001\r\u0001 \u0005\u0007i\u0006\u0005\u0001\u0019\u00019\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014\u0005!1m\u001c9z)\r\u0011\u0012Q\u0003\u0005\t\u0003/\ty\u00011\u0001\u0002\u001a\u0005)Q\r\u001f;sCB!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u0011\tQ\u0001]1sC6LA!a\t\u0002\u001e\tA\u0001+\u0019:b[6\u000b\u0007\u000fC\u0004\u0002(\u0001!\t%!\u000b\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!a\u000b\u00028A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022!\u000bQ\u0001^=qKNLA!!\u000e\u00020\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005e\u0012Q\u0005a\u0001\u0003W\taa]2iK6\f\u0007\u0006BA\u0013\u0003{\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u00072\u0011AC1o]>$\u0018\r^5p]&!\u0011qIA!\u00051!UM^3m_B,'/\u00119j\u0001")
public class CRRSamplerModel
extends Model<CRRSamplerModel>
implements DefaultParamsWritable,
CRRSamplerParams,
HasNetlibBlas {
    private final String uid;
    private final DoubleParam groupSampleRate;
    private final DoubleParam itemSampleRate;
    private final DoubleParam rankingPower;
    private final IntParam shuffleToPartitions;
    private final Param<String> labelCol;
    private final StringArrayParam groupByColumns;
    private final Param<String> inputCol;

    @Override
    public BLAS f2jBLAS() {
        return HasNetlibBlas$class.f2jBLAS(this);
    }

    @Override
    public BLAS blas() {
        return HasNetlibBlas$class.blas(this);
    }

    @Override
    public void dscal(double a, double[] data) {
        HasNetlibBlas$class.dscal(this, a, data);
    }

    @Override
    public void axpy(double a, double[] x, double[] y) {
        HasNetlibBlas$class.axpy((HasNetlibBlas)this, a, x, y);
    }

    @Override
    public void axpy(double a, Vector x, double[] y) {
        HasNetlibBlas$class.axpy((HasNetlibBlas)this, a, x, y);
    }

    @Override
    public void copy(double[] x, double[] y) {
        HasNetlibBlas$class.copy(this, x, y);
    }

    @Override
    public DoubleParam groupSampleRate() {
        return this.groupSampleRate;
    }

    @Override
    public DoubleParam itemSampleRate() {
        return this.itemSampleRate;
    }

    @Override
    public DoubleParam rankingPower() {
        return this.rankingPower;
    }

    @Override
    public IntParam shuffleToPartitions() {
        return this.shuffleToPartitions;
    }

    @Override
    public void org$apache$spark$ml$odkl$CRRSamplerParams$_setter_$groupSampleRate_$eq(DoubleParam x$1) {
        this.groupSampleRate = x$1;
    }

    @Override
    public void org$apache$spark$ml$odkl$CRRSamplerParams$_setter_$itemSampleRate_$eq(DoubleParam x$1) {
        this.itemSampleRate = x$1;
    }

    @Override
    public void org$apache$spark$ml$odkl$CRRSamplerParams$_setter_$rankingPower_$eq(DoubleParam x$1) {
        this.rankingPower = x$1;
    }

    @Override
    public void org$apache$spark$ml$odkl$CRRSamplerParams$_setter_$shuffleToPartitions_$eq(IntParam x$1) {
        this.shuffleToPartitions = x$1;
    }

    @Override
    public CRRSamplerParams setGroupSampleRate(double value) {
        return CRRSamplerParams$class.setGroupSampleRate(this, value);
    }

    @Override
    public CRRSamplerParams setItemSampleRate(double value) {
        return CRRSamplerParams$class.setItemSampleRate(this, value);
    }

    @Override
    public CRRSamplerParams setRankingPower(double value) {
        return CRRSamplerParams$class.setRankingPower(this, value);
    }

    @Override
    public CRRSamplerParams setShufflerToPartitions(int value) {
        return CRRSamplerParams$class.setShufflerToPartitions(this, value);
    }

    public final Param<String> labelCol() {
        return this.labelCol;
    }

    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    public final String getLabelCol() {
        return HasLabelCol.class.getLabelCol((HasLabelCol)this);
    }

    @Override
    public final StringArrayParam groupByColumns() {
        return this.groupByColumns;
    }

    @Override
    public final void org$apache$spark$ml$odkl$HasGroupByColumns$_setter_$groupByColumns_$eq(StringArrayParam x$1) {
        this.groupByColumns = x$1;
    }

    @Override
    public HasGroupByColumns setGroupByColumns(Seq<String> columns) {
        return HasGroupByColumns$class.setGroupByColumns(this, columns);
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    public final String getInputCol() {
        return HasInputCol.class.getInputCol((HasInputCol)this);
    }

    public MLWriter write() {
        return DefaultParamsWritable.class.write((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    public String uid() {
        return this.uid;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isDefined((Param)this.groupByColumns()) && ((String[])this.$((Param)this.groupByColumns())).length > 0) {
            if (((String[])this.$((Param)this.groupByColumns())).length == 1) {
                tuple32 = new Tuple3(dataset, (Object)BoxesRunTime.boxToInteger((int)dataset.schema().fieldIndex((String)Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.groupByColumns())).head())), (Object)None$.MODULE$);
            } else {
                Column keyStruct = functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.groupByColumns())).map((Function1)new Serializable(this, dataset){
                    public static final long serialVersionUID = 0L;
                    private final Dataset dataset$1;

                    public final Column apply(String x) {
                        return this.dataset$1.apply(x);
                    }
                    {
                        this.dataset$1 = dataset$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
                String keyName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_tmpKey"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid()}));
                Dataset data = dataset.withColumn(keyName, keyStruct);
                tuple32 = new Tuple3((Object)data, (Object)BoxesRunTime.boxToInteger((int)data.schema().fieldIndex(keyName)), (Object)new Some((Object)keyName));
            }
        } else {
            String keyName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_tmpKey"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid()}));
            Dataset data = dataset.withColumn(keyName, functions$.MODULE$.lit((Object)keyName));
            tuple32 = tuple3 = new Tuple3((Object)data, (Object)BoxesRunTime.boxToInteger((int)data.schema().fieldIndex(keyName)), (Object)new Some((Object)keyName));
        }
        if (tuple3 != null) {
            Tuple3 tuple33;
            Dataset data = (Dataset)tuple3._1();
            int keyIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Option toDrop = (Option)tuple3._3();
            Tuple3 tuple34 = tuple33 = new Tuple3((Object)data, (Object)BoxesRunTime.boxToInteger((int)keyIndex), (Object)toDrop);
            Dataset data2 = (Dataset)tuple34._1();
            int keyIndex2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
            Option toDrop2 = (Option)tuple34._3();
            int featuresIndex = data2.schema().fieldIndex((String)this.$(this.inputCol()));
            int labelIndex = data2.schema().fieldIndex((String)this.$(this.labelCol()));
            Dataset result = dataset.sqlContext().createDataFrame(RDDOperations$.MODULE$.ImplicitRDDDecorator(data2.toDF().rdd(), ClassTag$.MODULE$.apply(Row.class)).groupWithinPartitionsBy(new Serializable(this, keyIndex2){
                public static final long serialVersionUID = 0L;
                private final int keyIndex$1;

                public final Object apply(Row x) {
                    return x.get(this.keyIndex$1);
                }
                {
                    this.keyIndex$1 = keyIndex$1;
                }
            }, ClassTag$.MODULE$.Any()).flatMap((Function1)new Serializable(this, featuresIndex, labelIndex){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CRRSamplerModel $outer;
                private final int featuresIndex$1;
                private final int labelIndex$1;

                public final Iterator<Row> apply(Tuple2<Object, Iterator<Row>> x) {
                    return this.$outer.sampleRows((Iterator<Row>)((Iterator)x._2()), this.labelIndex$1, this.featuresIndex$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.featuresIndex$1 = featuresIndex$1;
                    this.labelIndex$1 = labelIndex$1;
                }
            }, ClassTag$.MODULE$.apply(Row.class)), data2.schema());
            Dataset noExtraColumn = (Dataset)toDrop2.map((Function1)new Serializable(this, result){
                public static final long serialVersionUID = 0L;
                private final Dataset result$1;

                public final Dataset<Row> apply(String x) {
                    return this.result$1.drop(x);
                }
                {
                    this.result$1 = result$1;
                }
            }).getOrElse((Function0)new Serializable(this, result){
                public static final long serialVersionUID = 0L;
                private final Dataset result$1;

                public final Dataset<Row> apply() {
                    return this.result$1;
                }
                {
                    this.result$1 = result$1;
                }
            });
            return (Dataset)this.get((Param)this.shuffleToPartitions()).map((Function1)new Serializable(this, noExtraColumn){
                public static final long serialVersionUID = 0L;
                private final Dataset noExtraColumn$1;

                public final Dataset<Row> apply(int x) {
                    return this.noExtraColumn$1.repartition(x);
                }
                {
                    this.noExtraColumn$1 = noExtraColumn$1;
                }
            }).getOrElse((Function0)new Serializable(this, noExtraColumn){
                public static final long serialVersionUID = 0L;
                private final Dataset noExtraColumn$1;

                public final Dataset<Row> apply() {
                    return this.noExtraColumn$1;
                }
                {
                    this.noExtraColumn$1 = noExtraColumn$1;
                }
            });
        }
        throw new MatchError((Object)tuple3);
    }

    public Iterator<Row> sampleRows(Iterator<Row> rows, int labelIndex, int featureIndex) {
        Iterator iterator;
        if (BoxesRunTime.unboxToDouble((Object)this.$((Param)this.groupSampleRate())) < 1.0 && ThreadLocalRandom.current().nextDouble() > BoxesRunTime.unboxToDouble((Object)this.$((Param)this.groupSampleRate()))) {
            iterator = package$.MODULE$.Iterator().empty();
        } else if (BoxesRunTime.unboxToDouble((Object)this.$((Param)this.rankingPower())) > 0.0) {
            CompactBuffer positives = new CompactBuffer(ClassTag$.MODULE$.apply(Row.class));
            CompactBuffer<Row> negatives = new CompactBuffer<Row>(ClassTag$.MODULE$.apply(Row.class));
            rows.foreach((Function1)new Serializable(this, labelIndex, positives, negatives){
                public static final long serialVersionUID = 0L;
                private final int labelIndex$2;
                private final CompactBuffer positives$1;
                private final CompactBuffer negatives$1;

                public final CompactBuffer<Row> apply(Row x) {
                    return x.getDouble(this.labelIndex$2) > 0.0 ? this.positives$1.$plus$eq(x) : this.negatives$1.$plus$eq(x);
                }
                {
                    this.labelIndex$2 = labelIndex$2;
                    this.positives$1 = positives$1;
                    this.negatives$1 = negatives$1;
                }
            });
            iterator = positives.isEmpty() || negatives.isEmpty() ? package$.MODULE$.Iterator().empty() : this.counterSample(positives.iterator(), negatives, featureIndex).$plus$plus((Function0)new Serializable(this, featureIndex, positives, negatives){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CRRSamplerModel $outer;
                private final int featureIndex$1;
                private final CompactBuffer positives$1;
                private final CompactBuffer negatives$1;

                public final Iterator<Row> apply() {
                    return this.$outer.counterSample(this.negatives$1.iterator(), this.positives$1, this.featureIndex$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.featureIndex$1 = featureIndex$1;
                    this.positives$1 = positives$1;
                    this.negatives$1 = negatives$1;
                }
            });
        } else {
            iterator = this.counterSample(rows, (Seq<Row>)((Seq)Seq$.MODULE$.empty()), featureIndex);
        }
        return iterator;
    }

    public Iterator<Row> counterSample(Iterator<Row> source, Seq<Row> counterPart, int featureIndex) {
        Iterator sampled;
        Iterator iterator = sampled = BoxesRunTime.unboxToDouble((Object)this.$((Param)this.itemSampleRate())) < 1.0 ? source.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CRRSamplerModel $outer;

            public final boolean apply(Row x$2) {
                return ThreadLocalRandom.current().nextDouble() < BoxesRunTime.unboxToDouble((Object)this.$outer.$((Param)this.$outer.itemSampleRate()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }) : source;
        return BoxesRunTime.unboxToDouble((Object)this.$((Param)this.rankingPower())) <= 0.0 ? sampled : (BoxesRunTime.unboxToDouble((Object)this.$((Param)this.rankingPower())) < 1.0 ? sampled.map((Function1)new Serializable(this, counterPart, featureIndex){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CRRSamplerModel $outer;
            private final Seq counterPart$1;
            private final int featureIndex$2;

            public final Row apply(Row x) {
                return this.$outer.pairSample(x, (Seq<Row>)this.counterPart$1, this.featureIndex$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.counterPart$1 = counterPart$1;
                this.featureIndex$2 = featureIndex$2;
            }
        }) : sampled.map((Function1)new Serializable(this, counterPart, featureIndex){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CRRSamplerModel $outer;
            private final Seq counterPart$1;
            private final int featureIndex$2;

            public final Row apply(Row x) {
                return ThreadLocalRandom.current().nextDouble() < BoxesRunTime.unboxToDouble((Object)this.$outer.$((Param)this.$outer.rankingPower())) ? this.$outer.pairSample(x, (Seq<Row>)this.counterPart$1, this.featureIndex$2) : x;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.counterPart$1 = counterPart$1;
                this.featureIndex$2 = featureIndex$2;
            }
        }));
    }

    public Row pairSample(Row sample2, Seq<Row> counterPart, int featureIndex) {
        Vector counterSample2 = (Vector)((Row)counterPart.apply(ThreadLocalRandom.current().nextInt(counterPart.size()))).getAs(featureIndex);
        Object[] result = (Object[])Array$.MODULE$.tabulate(sample2.length(), (Function1)new Serializable(this, sample2, featureIndex, counterSample2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CRRSamplerModel $outer;
            private final Row sample$1;
            private final int featureIndex$3;
            private final Vector counterSample$1;

            /*
             * WARNING - void declaration
             */
            public final Object apply(int i) {
                Object object;
                if (i == this.featureIndex$3) {
                    void var3_3;
                    Vector features = (Vector)this.sample$1.getAs(this.featureIndex$3);
                    DenseVector result = Vectors$.MODULE$.zeros(features.size()).toDense();
                    this.$outer.axpy(1.0, features, result.values());
                    this.$outer.axpy(-1.0, this.counterSample$1, result.values());
                    object = var3_3;
                } else {
                    object = this.sample$1.get(i);
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sample$1 = sample$1;
                this.featureIndex$3 = featureIndex$3;
                this.counterSample$1 = counterSample$1;
            }
        }, ClassTag$.MODULE$.Any());
        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)result));
    }

    public CRRSamplerModel copy(ParamMap extra) {
        return (CRRSamplerModel)this.defaultCopy(extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return schema;
    }

    public CRRSamplerModel(String uid) {
        this.uid = uid;
        MLWritable.class.$init$((MLWritable)this);
        DefaultParamsWritable.class.$init$((DefaultParamsWritable)this);
        HasInputCol.class.$init$((HasInputCol)this);
        HasGroupByColumns$class.$init$(this);
        HasLabelCol.class.$init$((HasLabelCol)this);
        CRRSamplerParams$class.$init$(this);
        HasNetlibBlas$class.$init$(this);
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.groupSampleRate().$minus$greater((Object)BoxesRunTime.boxToDouble((double)1.0)), this.itemSampleRate().$minus$greater((Object)BoxesRunTime.boxToDouble((double)1.0))}));
    }

    public CRRSamplerModel() {
        this(Identifiable$.MODULE$.randomUID("crrSampler"));
    }
}

