/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import breeze.generic.UFunc;
import breeze.numerics.package;
import java.util.Comparator;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.spark.ml.odkl.PartitionedRankingEvaluator;
import org.apache.spark.ml.odkl.PartitionedRankingEvaluator$;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class PartitionedRankingEvaluator$
implements Serializable {
    public static final PartitionedRankingEvaluator$ MODULE$;
    private transient Object byScoreComparator;
    private transient Object byLabelComparator;
    private volatile transient byte bitmap$trans$0;

    static {
        new PartitionedRankingEvaluator$();
    }

    private Comparator byScoreComparator$lzycompute() {
        PartitionedRankingEvaluator$ partitionedRankingEvaluator$ = this;
        synchronized (partitionedRankingEvaluator$) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.byScoreComparator = new Comparator<PartitionedRankingEvaluator.ScoreLabel>(){

                    public int compare(PartitionedRankingEvaluator.ScoreLabel o1, PartitionedRankingEvaluator.ScoreLabel o2) {
                        return NumberUtils.compare((double)o2.score(), (double)o1.score());
                    }
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.byScoreComparator;
        }
    }

    private Comparator byLabelComparator$lzycompute() {
        PartitionedRankingEvaluator$ partitionedRankingEvaluator$ = this;
        synchronized (partitionedRankingEvaluator$) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.byLabelComparator = new Comparator<PartitionedRankingEvaluator.ScoreLabel>(){

                    public int compare(PartitionedRankingEvaluator.ScoreLabel o1, PartitionedRankingEvaluator.ScoreLabel o2) {
                        return NumberUtils.compare((double)o2.label(), (double)o1.label());
                    }
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.byLabelComparator;
        }
    }

    public Object byScoreComparator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.byScoreComparator$lzycompute() : this.byScoreComparator;
    }

    public Object byLabelComparator() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.byLabelComparator$lzycompute() : this.byLabelComparator;
    }

    public PartitionedRankingEvaluator.Metric auc(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                PartitionedRankingEvaluator.AucAccumulator accumulator = (PartitionedRankingEvaluator.AucAccumulator)byScore.foldLeft((Object)new PartitionedRankingEvaluator.AucAccumulator(0, 0, 0, 0), (Function2)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$1;

                    public final PartitionedRankingEvaluator.AucAccumulator apply(PartitionedRankingEvaluator.AucAccumulator accumulated, PartitionedRankingEvaluator.ScoreLabel current) {
                        PartitionedRankingEvaluator.AucAccumulator aucAccumulator;
                        if (current.label() >= this.labelRelevanceThreshold$1) {
                            int x$16 = accumulated.height() + 1;
                            int x$17 = accumulated.positives() + 1;
                            int x$18 = accumulated.copy$default$2();
                            int x$19 = accumulated.copy$default$4();
                            aucAccumulator = accumulated.copy(x$16, x$18, x$17, x$19);
                        } else {
                            int x$20 = accumulated.area() + accumulated.height();
                            int x$21 = accumulated.negatives() + 1;
                            int x$22 = accumulated.copy$default$1();
                            int x$23 = accumulated.copy$default$3();
                            aucAccumulator = accumulated.copy(x$22, x$20, x$23, x$21);
                        }
                        return aucAccumulator;
                    }
                    {
                        this.labelRelevanceThreshold$1 = labelRelevanceThreshold$1;
                    }
                });
                int denomintor = accumulator.negatives() * byLabel.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$1;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$4) {
                        return x$4.label() >= this.labelRelevanceThreshold$1;
                    }
                    {
                        this.labelRelevanceThreshold$1 = labelRelevanceThreshold$1;
                    }
                });
                return denomintor == 0 ? Double.NaN : (double)accumulator.area() / (double)denomintor;
            }
        });
    }

    public String auc$default$1() {
        return "auc";
    }

    public PartitionedRankingEvaluator.Metric numPositives(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byLabel.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$2;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$5) {
                        return x$5.label() >= this.labelRelevanceThreshold$2;
                    }
                    {
                        this.labelRelevanceThreshold$2 = labelRelevanceThreshold$2;
                    }
                });
            }
        });
    }

    public String numPositives$default$1() {
        return "numPositives";
    }

    public PartitionedRankingEvaluator.Metric foundPositives(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$3;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$6) {
                        return x$6.label() >= this.labelRelevanceThreshold$3;
                    }
                    {
                        this.labelRelevanceThreshold$3 = labelRelevanceThreshold$3;
                    }
                });
            }
        });
    }

    public String foundPositives$default$1() {
        return "foundPositives";
    }

    public PartitionedRankingEvaluator.Metric countIf(String name, Function1<Row, Object> filter) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(filter){
            public static final long serialVersionUID = 0L;
            public final Function1 filter$1;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countIf.1 $outer;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$1.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.filter$1 = filter$1;
            }
        });
    }

    public PartitionedRankingEvaluator.Metric countIfAt(String name, int size, Function1<Row, Object> filter) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(size, filter){
            public static final long serialVersionUID = 0L;
            private final int size$1;
            public final Function1 filter$2;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.take(this.size$1).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countIfAt.1 $outer;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$2.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.size$1 = size$1;
                this.filter$2 = filter$2;
            }
        });
    }

    public PartitionedRankingEvaluator.Metric countRelevantIf(String name, Function1<Row, Object> filter) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(filter){
            public static final long serialVersionUID = 0L;
            public final Function1 filter$3;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countRelevantIf.1 $outer;
                    private final double labelRelevanceThreshold$4;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return x.label() >= this.labelRelevanceThreshold$4 && BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$3.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.labelRelevanceThreshold$4 = labelRelevanceThreshold$4;
                    }
                });
            }
            {
                this.filter$3 = filter$3;
            }
        });
    }

    public PartitionedRankingEvaluator.Metric countRelevantIfAt(String name, int size, Function1<Row, Object> filter) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(size, filter){
            public static final long serialVersionUID = 0L;
            private final int size$2;
            public final Function1 filter$4;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.take(this.size$2).count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countRelevantIfAt.1 $outer;
                    private final double labelRelevanceThreshold$5;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return x.label() >= this.labelRelevanceThreshold$5 && BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$4.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.labelRelevanceThreshold$5 = labelRelevanceThreshold$5;
                    }
                });
            }
            {
                this.size$2 = size$2;
                this.filter$4 = filter$4;
            }
        });
    }

    public <T> PartitionedRankingEvaluator.Metric countDistinctIf(String name, Function1<Row, Object> filter, Function1<Row, T> extractor) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(filter, extractor){
            public static final long serialVersionUID = 0L;
            public final Function1 filter$5;
            public final Function1 extractor$1;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctIf.1 $outer;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$5.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctIf.1 $outer;

                    public final T apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return (T)this.$outer.extractor$1.apply((Object)x.row());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toSet().size();
            }
            {
                this.filter$5 = filter$5;
                this.extractor$1 = extractor$1;
            }
        });
    }

    public <T> PartitionedRankingEvaluator.Metric countDistinctRelevantIf(String name, Function1<Row, Object> filter, Function1<Row, T> extractor) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(filter, extractor){
            public static final long serialVersionUID = 0L;
            public final Function1 filter$6;
            public final Function1 extractor$2;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.filter((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctRelevantIf.1 $outer;
                    private final double labelRelevanceThreshold$6;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return x.label() >= this.labelRelevanceThreshold$6 && BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$6.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.labelRelevanceThreshold$6 = labelRelevanceThreshold$6;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctRelevantIf.1 $outer;

                    public final T apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return (T)this.$outer.extractor$2.apply((Object)x.row());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toSet().size();
            }
            {
                this.filter$6 = filter$6;
                this.extractor$2 = extractor$2;
            }
        });
    }

    public <T> PartitionedRankingEvaluator.Metric countDistinctIfAt(String name, int size, Function1<Row, Object> filter, Function1<Row, T> extractor) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(size, filter, extractor){
            public static final long serialVersionUID = 0L;
            private final int size$3;
            public final Function1 filter$7;
            public final Function1 extractor$3;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.take(this.size$3).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctIfAt.1 $outer;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$7.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctIfAt.1 $outer;

                    public final T apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return (T)this.$outer.extractor$3.apply((Object)x.row());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toSet().size();
            }
            {
                this.size$3 = size$3;
                this.filter$7 = filter$7;
                this.extractor$3 = extractor$3;
            }
        });
    }

    public <T> PartitionedRankingEvaluator.Metric countDistinctRelevantIfAt(String name, int size, Function1<Row, Object> filter, Function1<Row, T> extractor) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(size, filter, extractor){
            public static final long serialVersionUID = 0L;
            private final int size$4;
            public final Function1 filter$8;
            public final Function1 extractor$4;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.take(this.size$4).filter((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctRelevantIfAt.1 $outer;
                    private final double labelRelevanceThreshold$7;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return x.label() >= this.labelRelevanceThreshold$7 && BoxesRunTime.unboxToBoolean((Object)this.$outer.filter$8.apply((Object)x.row()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.labelRelevanceThreshold$7 = labelRelevanceThreshold$7;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.countDistinctRelevantIfAt.1 $outer;

                    public final T apply(PartitionedRankingEvaluator.ScoreLabel x) {
                        return (T)this.$outer.extractor$4.apply((Object)x.row());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toSet().size();
            }
            {
                this.size$4 = size$4;
                this.filter$8 = filter$8;
                this.extractor$4 = extractor$4;
            }
        });
    }

    public PartitionedRankingEvaluator.Metric numNegatives(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byLabel.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$8;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$7) {
                        return x$7.label() < this.labelRelevanceThreshold$8;
                    }
                    {
                        this.labelRelevanceThreshold$8 = labelRelevanceThreshold$8;
                    }
                });
            }
        });
    }

    public String numNegatives$default$1() {
        return "numNegatives";
    }

    public PartitionedRankingEvaluator.Metric foundNegatves(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return byScore.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$9;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$8) {
                        return x$8.label() < this.labelRelevanceThreshold$9;
                    }
                    {
                        this.labelRelevanceThreshold$9 = labelRelevanceThreshold$9;
                    }
                });
            }
        });
    }

    public String foundNegatves$default$1() {
        return "foundNegatives";
    }

    public PartitionedRankingEvaluator.Metric precision(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                double d;
                if (byScore.nonEmpty()) {
                    IntRef size = IntRef.create((int)0);
                    IntRef relevant = IntRef.create((int)0);
                    byScore.foreach((Function1)new Serializable(this, size, relevant, labelRelevanceThreshold){
                        public static final long serialVersionUID = 0L;
                        private final IntRef size$5;
                        private final IntRef relevant$1;
                        private final double labelRelevanceThreshold$10;

                        public final void apply(PartitionedRankingEvaluator.ScoreLabel i) {
                            ++this.size$5.elem;
                            if (i.label() >= this.labelRelevanceThreshold$10) {
                                ++this.relevant$1.elem;
                            }
                        }
                        {
                            this.size$5 = size$5;
                            this.relevant$1 = relevant$1;
                            this.labelRelevanceThreshold$10 = labelRelevanceThreshold$10;
                        }
                    });
                    d = (double)relevant.elem / (double)size.elem;
                } else {
                    d = byLabel.count((Function1)new Serializable(this, labelRelevanceThreshold){
                        public static final long serialVersionUID = 0L;
                        private final double labelRelevanceThreshold$10;

                        public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$9) {
                            return x$9.label() >= this.labelRelevanceThreshold$10;
                        }
                        {
                            this.labelRelevanceThreshold$10 = labelRelevanceThreshold$10;
                        }
                    }) > 0 ? 0.0 : Double.NaN;
                }
                return d;
            }
        });
    }

    public String precision$default$1() {
        return "precision";
    }

    public PartitionedRankingEvaluator.Metric recall(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                int allPositive = byLabel.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$11;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$10) {
                        return x$10.label() >= this.labelRelevanceThreshold$11;
                    }
                    {
                        this.labelRelevanceThreshold$11 = labelRelevanceThreshold$11;
                    }
                });
                return allPositive > 0 ? (double)byScore.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$11;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$11) {
                        return x$11.label() >= this.labelRelevanceThreshold$11;
                    }
                    {
                        this.labelRelevanceThreshold$11 = labelRelevanceThreshold$11;
                    }
                }) / (double)allPositive : Double.NaN;
            }
        });
    }

    public String recall$default$1() {
        return "recall";
    }

    public PartitionedRankingEvaluator.Metric precisionAt(int at, Option<String> name) {
        return new PartitionedRankingEvaluator.Metric((String)name.getOrElse((Function0)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"precisionAt", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.at$1)}));
            }
            {
                this.at$1 = at$1;
            }
        }), (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$1;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return PartitionedRankingEvaluator$.MODULE$.precision(PartitionedRankingEvaluator$.MODULE$.precision$default$1()).apply(byLabel, (Iterator<PartitionedRankingEvaluator.ScoreLabel>)byScore.take(this.at$1), labelRelevanceThreshold);
            }
            {
                this.at$1 = at$1;
            }
        });
    }

    public Option<String> precisionAt$default$2() {
        return None$.MODULE$;
    }

    public PartitionedRankingEvaluator.Metric recallAt(int at, Option<String> name) {
        return new PartitionedRankingEvaluator.Metric((String)name.getOrElse((Function0)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recalAt", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.at$2)}));
            }
            {
                this.at$2 = at$2;
            }
        }), (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$2;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return PartitionedRankingEvaluator$.MODULE$.recall(PartitionedRankingEvaluator$.MODULE$.recall$default$1()).apply((Iterable<PartitionedRankingEvaluator.ScoreLabel>)((Iterable)byLabel.take(this.at$2)), (Iterator<PartitionedRankingEvaluator.ScoreLabel>)byScore.take(this.at$2), labelRelevanceThreshold);
            }
            {
                this.at$2 = at$2;
            }
        });
    }

    public Option<String> recallAt$default$2() {
        return None$.MODULE$;
    }

    public PartitionedRankingEvaluator.Metric f1(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                IntRef truePos = IntRef.create((int)0);
                IntRef allRecommended = IntRef.create((int)0);
                byScore.foreach((Function1)new Serializable(this, truePos, allRecommended, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final IntRef truePos$1;
                    private final IntRef allRecommended$1;
                    private final double labelRelevanceThreshold$12;

                    public final void apply(PartitionedRankingEvaluator.ScoreLabel i) {
                        ++this.allRecommended$1.elem;
                        if (i.label() >= this.labelRelevanceThreshold$12) {
                            ++this.truePos$1.elem;
                        }
                    }
                    {
                        this.truePos$1 = truePos$1;
                        this.allRecommended$1 = allRecommended$1;
                        this.labelRelevanceThreshold$12 = labelRelevanceThreshold$12;
                    }
                });
                int allPositive = byLabel.count((Function1)new Serializable(this, labelRelevanceThreshold){
                    public static final long serialVersionUID = 0L;
                    private final double labelRelevanceThreshold$12;

                    public final boolean apply(PartitionedRankingEvaluator.ScoreLabel x$12) {
                        return x$12.label() >= this.labelRelevanceThreshold$12;
                    }
                    {
                        this.labelRelevanceThreshold$12 = labelRelevanceThreshold$12;
                    }
                });
                return allPositive > 0 ? 2.0 * (double)truePos.elem / (double)(allRecommended.elem + allPositive) : Double.NaN;
            }
        });
    }

    public String f1$default$1() {
        return "f1";
    }

    public PartitionedRankingEvaluator.Metric f1At(int at, Option<String> name) {
        return new PartitionedRankingEvaluator.Metric((String)name.getOrElse((Function0)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f1At", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.at$3)}));
            }
            {
                this.at$3 = at$3;
            }
        }), (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$3;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return PartitionedRankingEvaluator$.MODULE$.f1(PartitionedRankingEvaluator$.MODULE$.f1$default$1()).apply((Iterable<PartitionedRankingEvaluator.ScoreLabel>)((Iterable)byLabel.take(this.at$3)), (Iterator<PartitionedRankingEvaluator.ScoreLabel>)byScore.take(this.at$3), labelRelevanceThreshold);
            }
            {
                this.at$3 = at$3;
            }
        });
    }

    public Option<String> f1At$default$2() {
        return None$.MODULE$;
    }

    public PartitionedRankingEvaluator.Metric ndcgWeak(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return PartitionedRankingEvaluator$.MODULE$.relativeSortedMetric(byLabel, byScore, (Function2<Object, Tuple2<PartitionedRankingEvaluator.ScoreLabel, Object>, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double accumulated, Tuple2<PartitionedRankingEvaluator.ScoreLabel, Object> current) {
                        return accumulated + ((PartitionedRankingEvaluator.ScoreLabel)current._1()).label() / (current._2$mcI$sp() == 0 ? 1.0 : package.log2$.MODULE$.apply$mIDc$sp(current._2$mcI$sp() + 1, (UFunc.UImpl)package.log2$.log2IntImpl$.MODULE$));
                    }
                }, PartitionedRankingEvaluator$.MODULE$.relativeSortedMetric$default$4());
            }
        });
    }

    public String ndcgWeak$default$1() {
        return "ndcgWeak";
    }

    public PartitionedRankingEvaluator.Metric ndcgWeakAt(int at, Option<String> name) {
        return new PartitionedRankingEvaluator.Metric((String)name.getOrElse((Function0)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ndcgWeakAt", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.at$4)}));
            }
            {
                this.at$4 = at$4;
            }
        }), (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$4;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return PartitionedRankingEvaluator$.MODULE$.ndcgWeak(PartitionedRankingEvaluator$.MODULE$.ndcgWeak$default$1()).apply((Iterable<PartitionedRankingEvaluator.ScoreLabel>)((Iterable)byLabel.take(this.at$4)), (Iterator<PartitionedRankingEvaluator.ScoreLabel>)byScore.take(this.at$4), labelRelevanceThreshold);
            }
            {
                this.at$4 = at$4;
            }
        });
    }

    public Option<String> ndcgWeakAt$default$2() {
        return None$.MODULE$;
    }

    public PartitionedRankingEvaluator.Metric ndcgStrong(String name) {
        return new PartitionedRankingEvaluator.Metric(name, (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return PartitionedRankingEvaluator$.MODULE$.relativeSortedMetric(byLabel, byScore, (Function2<Object, Tuple2<PartitionedRankingEvaluator.ScoreLabel, Object>, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double accumulated, Tuple2<PartitionedRankingEvaluator.ScoreLabel, Object> current) {
                        return accumulated + (Math.pow(2.0, ((PartitionedRankingEvaluator.ScoreLabel)current._1()).label()) - 1.0) / package.log2$.MODULE$.apply$mIDc$sp(current._2$mcI$sp() + 2, (UFunc.UImpl)package.log2$.log2IntImpl$.MODULE$);
                    }
                }, PartitionedRankingEvaluator$.MODULE$.relativeSortedMetric$default$4());
            }
        });
    }

    public String ndcgStrong$default$1() {
        return "ndcg";
    }

    public PartitionedRankingEvaluator.Metric ndcgStrongAt(int at, Option<String> name) {
        return new PartitionedRankingEvaluator.Metric((String)name.getOrElse((Function0)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$5;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ndcgAt", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.at$5)}));
            }
            {
                this.at$5 = at$5;
            }
        }), (Function3<Iterable<PartitionedRankingEvaluator.ScoreLabel>, Iterator<PartitionedRankingEvaluator.ScoreLabel>, Object, Object>)new Serializable(at){
            public static final long serialVersionUID = 0L;
            private final int at$5;

            public final double apply(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, double labelRelevanceThreshold) {
                return PartitionedRankingEvaluator$.MODULE$.ndcgStrong(PartitionedRankingEvaluator$.MODULE$.ndcgStrong$default$1()).apply((Iterable<PartitionedRankingEvaluator.ScoreLabel>)((Iterable)byLabel.take(this.at$5)), (Iterator<PartitionedRankingEvaluator.ScoreLabel>)byScore.take(this.at$5), labelRelevanceThreshold);
            }
            {
                this.at$5 = at$5;
            }
        });
    }

    public Option<String> ndcgStrongAt$default$2() {
        return None$.MODULE$;
    }

    public double relativeSortedMetric(Iterable<PartitionedRankingEvaluator.ScoreLabel> byLabel, Iterator<PartitionedRankingEvaluator.ScoreLabel> byScore, Function2<Object, Tuple2<PartitionedRankingEvaluator.ScoreLabel, Object>, Object> op, double initial) {
        double ideal = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)byLabel.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToDouble((double)initial), op));
        double actual = BoxesRunTime.unboxToDouble((Object)byScore.zipWithIndex().foldLeft((Object)BoxesRunTime.boxToDouble((double)initial), op));
        return ideal == 0.0 ? Double.NaN : actual / ideal;
    }

    public double relativeSortedMetric$default$4() {
        return 0.0;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PartitionedRankingEvaluator$() {
        MODULE$ = this;
    }
}

