/*
 * Decompiled with CFR 0.152.
 */
package one.nio.async;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SettableFuture<V>
implements RunnableFuture<V> {
    protected V value;
    protected Throwable throwable;
    protected volatile boolean done;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!this.done) {
            this.waitForCompletion();
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            this.waitForCompletion(unit.toMillis(timeout));
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.value;
    }

    public synchronized void set(V value) {
        this.value = value;
        this.done = true;
        this.notifyAll();
    }

    public synchronized void setException(Throwable throwable) {
        this.throwable = throwable;
        this.done = true;
        this.notifyAll();
    }

    protected synchronized void waitForCompletion() throws InterruptedException {
        while (!this.done) {
            this.wait();
        }
    }

    protected synchronized void waitForCompletion(long timeout) throws InterruptedException, TimeoutException {
        long waitUntil = System.currentTimeMillis() + timeout;
        while (!this.done) {
            this.wait(timeout);
            timeout = waitUntil - System.currentTimeMillis();
            if (timeout > 0L) continue;
            throw new TimeoutException();
        }
    }

    @Override
    public void run() {
        this.set(null);
    }
}

