/*
 * Decompiled with CFR 0.152.
 */
package one.nio.compiler;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import one.nio.compiler.CompilationException;
import one.nio.compiler.MemoryInputFileObject;
import one.nio.compiler.MemoryOutputFileObject;
import one.nio.util.JavaInternals;
import one.nio.util.URLEncoder;
import sun.misc.URLClassPath;

public class Javac {
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
    private final String classPath;

    public Javac() {
        this(System.getProperty("java.class.path"));
    }

    public Javac(ClassLoader loader) {
        this(Javac.buildPathFromClassLoader(loader));
    }

    public Javac(String classPath) {
        this.classPath = classPath;
    }

    public byte[] compile(CharSequence code) throws CompilationException {
        CharArrayWriter messages = new CharArrayWriter();
        List<String> options = Arrays.asList("-classpath", this.classPath);
        final ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        ForwardingJavaFileManager<StandardJavaFileManager> manager = new ForwardingJavaFileManager<StandardJavaFileManager>(this.fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
                return new MemoryOutputFileObject(output);
            }
        };
        List<MemoryInputFileObject> input = Arrays.asList(new MemoryInputFileObject(code));
        if (this.compiler.getTask(messages, manager, null, options, null, input).call().booleanValue()) {
            return output.toByteArray();
        }
        throw new CompilationException(messages.toString());
    }

    private static String buildPathFromClassLoader(ClassLoader loader) {
        StringBuilder builder = new StringBuilder();
        Field ucp = JavaInternals.getField(URLClassLoader.class, "ucp");
        while (loader instanceof URLClassLoader) {
            for (URL url : Javac.getURLsFromClassLoader((URLClassLoader)loader, ucp)) {
                if (!"file".equals(url.getProtocol())) continue;
                String file = URLEncoder.decode(url.getFile());
                builder.append(file).append(File.pathSeparatorChar);
            }
            loader = loader.getParent();
        }
        return builder.toString();
    }

    private static URL[] getURLsFromClassLoader(URLClassLoader loader, Field ucp) {
        if (ucp != null) {
            try {
                return ((URLClassPath)ucp.get(loader)).getURLs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return loader.getURLs();
    }
}

