/*
 * Decompiled with CFR 0.152.
 */
package one.nio.config;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import one.nio.config.Config;
import one.nio.config.Converter;
import one.nio.util.JavaInternals;

public class ConfigParser {
    private final StringTokenizer st;
    private String line;
    private int indent;

    private ConfigParser(String config) {
        this.st = new StringTokenizer(config, "\r\n");
        this.indent = -1;
    }

    public static <T> T parse(String config, Class<T> type) {
        ConfigParser parser = new ConfigParser(config);
        if (parser.nextLine() < 0) {
            throw new IllegalArgumentException("Unexpected end of input");
        }
        try {
            return (T)parser.parseValue(type, 0);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object parseValue(Class<?> type, int level) throws ReflectiveOperationException {
        if (type == String.class) {
            return this.tail();
        }
        if (type.isPrimitive()) {
            return this.parsePrimitive(type, this.tail());
        }
        if (type.isArray()) {
            return this.parseArray(type.getComponentType(), level);
        }
        if (type.isAnnotationPresent(Config.class)) {
            return this.parseBean(type, level);
        }
        Method method = JavaInternals.getMethod(type, "valueOf", String.class);
        if (method != null && (method.getModifiers() & 8) != 0 && type.isAssignableFrom(method.getReturnType())) {
            return method.invoke(null, this.tail());
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    private Object parseBean(Class<?> type, int minLevel) throws ReflectiveOperationException {
        Object obj = type.newInstance();
        this.fillBean(obj, minLevel);
        return obj;
    }

    private void fillBean(Object obj, int minLevel) throws ReflectiveOperationException {
        Map<String, Field> fields = ConfigParser.collectFields(obj.getClass());
        int level = this.nextLine();
        if (level >= minLevel) {
            do {
                int colon;
                if ((colon = this.line.indexOf(58, level)) < 0) {
                    throw new IllegalArgumentException("Field expected: " + this.line);
                }
                Field f = fields.get(this.line.substring(level, colon));
                if (f == null) {
                    throw new IllegalArgumentException("Unknown field: " + this.line);
                }
                this.skipSpaces(colon + 1);
                Converter converter = f.getAnnotation(Converter.class);
                Object value = converter != null ? this.convert(this.tail(), converter) : this.parseValue(f.getType(), level + 1);
                f.set(obj, value);
            } while (this.nextLine() == level);
        }
    }

    private Object convert(String value, Converter converter) throws ReflectiveOperationException {
        Class<?> cls = converter.value();
        Method method = JavaInternals.getMethod(cls, converter.method(), String.class);
        if (method == null) {
            throw new IllegalArgumentException("Invalid converter class: " + cls.getName());
        }
        Object sender = (method.getModifiers() & 8) != 0 ? null : cls.newInstance();
        return method.invoke(sender, value);
    }

    private Object parseArray(Class<?> componentType, int minLevel) throws ReflectiveOperationException {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.hasTail()) {
            if (componentType != String.class && !componentType.isPrimitive()) {
                throw new IllegalArgumentException("Array is expected");
            }
            elements.add(this.parseValue(componentType, -1));
        } else {
            int level = this.nextLine();
            if (level >= minLevel && this.line.charAt(level) == '-') {
                do {
                    this.skipSpaces(level + 1);
                    Object value = this.parseValue(componentType, level + 1);
                    elements.add(value);
                } while (this.nextLine() == level && this.line.charAt(level) == '-');
            }
        }
        Object array = Array.newInstance(componentType, elements.size());
        if (componentType.isPrimitive()) {
            for (int i = 0; i < elements.size(); ++i) {
                Array.set(array, i, elements.get(i));
            }
            return array;
        }
        return elements.toArray((Object[])array);
    }

    private Object parsePrimitive(Class<?> type, String value) {
        if (type == Boolean.TYPE) {
            return "true".equalsIgnoreCase(value);
        }
        if (type == Byte.TYPE) {
            return Byte.decode(value);
        }
        if (type == Short.TYPE) {
            return Short.decode(value);
        }
        if (type == Integer.TYPE) {
            return Integer.decode(value);
        }
        if (type == Long.TYPE) {
            return Long.decode(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    private static Map<String, Field> collectFields(Class<?> cls) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        while (cls != Object.class) {
            for (Field f : cls.getDeclaredFields()) {
                if ((f.getModifiers() & 0x1088) != 0) continue;
                f.setAccessible(true);
                map.put(f.getName(), f);
            }
            cls = cls.getSuperclass();
        }
        return map;
    }

    private int nextLine() {
        if (this.indent >= 0) {
            return this.indent;
        }
        block0: while (this.st.hasMoreTokens()) {
            String s = this.st.nextToken();
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c == '#') continue block0;
                this.line = s;
                this.indent = i;
                return this.indent;
            }
        }
        this.indent = -1;
        return -1;
    }

    private void skipSpaces(int from) {
        int length = this.line.length();
        for (int i = from; i < length; ++i) {
            char c = this.line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (c == '#') break;
            this.indent = i;
            return;
        }
        this.indent = -1;
    }

    private String tail() {
        String result = this.indent >= 0 ? this.line.substring(this.indent) : "";
        this.indent = -1;
        return result;
    }

    private boolean hasTail() {
        return this.indent >= 0 && this.indent < this.line.length();
    }
}

