/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import one.nio.http.HttpSession;
import one.nio.http.Path;
import one.nio.http.Request;
import one.nio.http.RequestHandler;
import one.nio.http.Response;
import one.nio.http.gen.RequestHandlerGenerator;
import one.nio.net.Socket;
import one.nio.server.RejectedSessionException;
import one.nio.server.Server;
import one.nio.server.ServerConfig;

public class HttpServer
extends Server {
    protected final HashMap<String, RequestHandler> requestHandlers = new HashMap();

    public HttpServer(ServerConfig config, Object ... routers) throws IOException {
        super(config);
        this.addRequestHandlers(this);
        for (Object router : routers) {
            this.addRequestHandlers(router);
        }
    }

    @Override
    public HttpSession createSession(Socket socket) throws RejectedSessionException {
        return new HttpSession(socket, this);
    }

    public void handleRequest(Request request, HttpSession session) throws IOException {
        RequestHandler requestHandler = this.requestHandlers.get(request.getPath());
        if (requestHandler != null) {
            requestHandler.handleRequest(request, session);
        } else {
            this.handleDefault(request, session);
        }
    }

    public void handleDefault(Request request, HttpSession session) throws IOException {
        Response response = new Response("404 Not Found", Response.EMPTY);
        session.sendResponse(response);
    }

    public void addRequestHandlers(Object router) {
        ArrayList supers = new ArrayList(4);
        for (Class<?> cls = router.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            supers.add(cls);
        }
        RequestHandlerGenerator generator = new RequestHandlerGenerator();
        int i = supers.size();
        while (--i >= 0) {
            for (Method m : ((Class)supers.get(i)).getMethods()) {
                Path annotation = m.getAnnotation(Path.class);
                if (annotation == null) continue;
                RequestHandler requestHandler = generator.generateFor(m, router);
                for (String path : annotation.value()) {
                    this.requestHandlers.put(path, requestHandler);
                }
            }
        }
    }
}

