/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.IOException;
import java.util.LinkedList;
import one.nio.http.HttpException;
import one.nio.http.HttpServer;
import one.nio.http.Request;
import one.nio.http.Response;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.net.SocketClosedException;
import one.nio.util.Utf8;

public class HttpSession
extends Session {
    private static final int MAX_HEADERS = 48;
    private static final int MAX_FRAGMENT_LENGTH = 2048;
    private static final int MAX_PIPELINE_LENGTH = 256;
    protected static final Request FIN = new Request(0, "", false);
    protected final HttpServer server;
    protected final LinkedList<Request> pipeline = new LinkedList();
    protected final byte[] fragment = new byte[2048];
    protected int fragmentLength;
    protected Request parsing;
    protected Request handling;

    public HttpSession(Socket socket, HttpServer server) {
        super(socket);
        this.server = server;
    }

    @Override
    public int checkStatus(long currentTime, long keepAlive) {
        long lastAccessTime = this.lastAccessTime;
        if (lastAccessTime < currentTime - keepAlive) {
            if (this.queueHead == null && this.handling == null) {
                return 1;
            }
            if (lastAccessTime < currentTime - keepAlive * 8L) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    protected void processRead(byte[] buffer) throws IOException {
        int length = this.fragmentLength;
        if (length > 0) {
            System.arraycopy(this.fragment, 0, buffer, 0, length);
        }
        try {
            length += super.read(buffer, length, buffer.length - length);
        }
        catch (SocketClosedException e) {
            this.handleSocketClosed();
            return;
        }
        try {
            int processed = this.processHttpBuffer(buffer, length);
            if ((length -= processed) > 0) {
                if (length > 2048) {
                    throw new HttpException("Line too long");
                }
                System.arraycopy(buffer, processed, this.fragment, 0, length);
            }
            this.fragmentLength = length;
        }
        catch (HttpException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Bad request", (Throwable)e);
            }
            this.sendError("400 Bad Request", e.getMessage());
        }
    }

    protected void handleSocketClosed() {
        if (this.closing) {
            return;
        }
        this.listen(this.queueHead == null ? 0 : 4);
        if (this.handling == null) {
            this.scheduleClose();
        } else {
            this.pipeline.addLast(FIN);
        }
    }

    protected int processHttpBuffer(byte[] buffer, int length) throws IOException, HttpException {
        int lineStart = 0;
        for (int i = 0; i < length; ++i) {
            if (buffer[i] != 10) continue;
            int lineLength = i - lineStart;
            if (i > 0 && buffer[i - 1] == 13) {
                --lineLength;
            }
            if (this.parsing == null) {
                this.parsing = this.parseRequest(buffer, lineStart, lineLength);
            } else if (lineLength > 0) {
                if (this.parsing.getHeaderCount() < 48) {
                    this.parsing.addHeader(Utf8.read(buffer, lineStart, lineLength));
                }
            } else {
                if (this.closing) {
                    return i + 1;
                }
                if (this.handling == null) {
                    this.handling = this.parsing;
                    this.server.handleRequest(this.handling, this);
                } else if (this.pipeline.size() < 256) {
                    this.pipeline.addLast(this.parsing);
                } else {
                    throw new IOException("Pipeline length exceeded");
                }
                this.parsing = null;
            }
            lineStart = i + 1;
        }
        return lineStart;
    }

    protected Request parseRequest(byte[] buffer, int start, int length) throws HttpException {
        boolean http11;
        boolean bl = http11 = length > 13 && buffer[start + length - 1] == 49;
        if (length > 13 && Utf8.startsWith(Request.VERB_GET, buffer, start)) {
            return new Request(1, Utf8.read(buffer, start + 4, length - 13), http11);
        }
        if (length > 14 && Utf8.startsWith(Request.VERB_POST, buffer, start)) {
            return new Request(2, Utf8.read(buffer, start + 5, length - 14), http11);
        }
        if (length > 14 && Utf8.startsWith(Request.VERB_HEAD, buffer, start)) {
            return new Request(3, Utf8.read(buffer, start + 5, length - 14), http11);
        }
        if (length > 17 && Utf8.startsWith(Request.VERB_OPTIONS, buffer, start)) {
            return new Request(4, Utf8.read(buffer, start + 8, length - 17), http11);
        }
        throw new HttpException("Invalid request");
    }

    public synchronized void sendResponse(Response response) throws IOException {
        if (this.handling == null) {
            throw new IOException("Out of order response");
        }
        this.server.incRequestsProcessed();
        String connection = this.handling.getHeader("Connection: ");
        boolean keepAlive = this.handling.isHttp11() ? !"close".equalsIgnoreCase(connection) : "Keep-Alive".equalsIgnoreCase(connection);
        response.addHeader(keepAlive ? "Connection: Keep-Alive" : "Connection: close");
        this.writeResponse(response, this.handling.getMethod() != 3);
        if (!keepAlive) {
            this.scheduleClose();
        }
        if ((this.handling = this.pipeline.pollFirst()) != null) {
            if (this.handling == FIN) {
                this.scheduleClose();
            } else {
                this.server.handleRequest(this.handling, this);
            }
        }
    }

    public synchronized void sendError(String code, String message) throws IOException {
        this.server.incRequestsRejected();
        Response response = new Response(code, message == null ? Response.EMPTY : Utf8.toBytes(message));
        response.addHeader("Connection: close");
        this.writeResponse(response, true);
        this.scheduleClose();
    }

    protected void writeResponse(Response response, boolean includeBody) throws IOException {
        byte[] bytes = response.toBytes(includeBody);
        super.write(bytes, 0, bytes.length);
    }
}

