/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import one.nio.util.JavaInternals;
import sun.misc.Cleaner;

public final class DirectMemory {
    private static final long addressOffset = JavaInternals.fieldOffset(Buffer.class, "address");
    private static final long capacityOffset = JavaInternals.fieldOffset(Buffer.class, "capacity");
    static final ByteBuffer prototype = ByteBuffer.allocateDirect(0);
    private static final long MAX_SETMEMORY_BYTES = 0x200000L;

    public static long allocate(long size, Object holder) {
        final long address = JavaInternals.unsafe.allocateMemory(size);
        Cleaner.create((Object)holder, (Runnable)new Runnable(){

            @Override
            public void run() {
                JavaInternals.unsafe.freeMemory(address);
            }
        });
        return address;
    }

    public static long allocateAndClear(long size, Object holder) {
        long address = DirectMemory.allocate(size, holder);
        DirectMemory.clear(address, size);
        return address;
    }

    public static long allocateRaw(long size) {
        long address = JavaInternals.unsafe.allocateMemory(size);
        DirectMemory.clear(address, size);
        return address;
    }

    public static void freeRaw(long address) {
        JavaInternals.unsafe.freeMemory(address);
    }

    public static void clear(long address, long size) {
        while (size > 0x200000L) {
            JavaInternals.unsafe.setMemory(address, 0x200000L, (byte)0);
            address += 0x200000L;
            size -= 0x200000L;
        }
        JavaInternals.unsafe.setMemory(address, size, (byte)0);
    }

    public static void clearSmall(long address, int size) {
        while (size >= 8) {
            JavaInternals.unsafe.putLong(address, 0L);
            address += 8L;
            size -= 8;
        }
        if ((size & 4) != 0) {
            JavaInternals.unsafe.putInt(address, 0);
            address += 4L;
        }
        if ((size & 2) != 0) {
            JavaInternals.unsafe.putShort(address, (short)0);
            address += 2L;
        }
        if ((size & 1) != 0) {
            JavaInternals.unsafe.putByte(address, (byte)0);
        }
    }

    public static long getAddress(ByteBuffer buffer) {
        return JavaInternals.unsafe.getLong(buffer, addressOffset);
    }

    public static ByteBuffer wrap(long address, int count) {
        ByteBuffer result = prototype.duplicate();
        JavaInternals.unsafe.putLong(result, addressOffset, address);
        JavaInternals.unsafe.putInt(result, capacityOffset, count);
        result.limit(count);
        return result;
    }

    public static boolean compare(Object obj1, long offset1, Object obj2, long offset2, int count) {
        while (count >= 8) {
            if (JavaInternals.unsafe.getLong(obj1, offset1) != JavaInternals.unsafe.getLong(obj2, offset2)) {
                return false;
            }
            offset1 += 8L;
            offset2 += 8L;
            count -= 8;
        }
        if ((count & 4) != 0) {
            if (JavaInternals.unsafe.getInt(obj1, offset1) != JavaInternals.unsafe.getInt(obj2, offset2)) {
                return false;
            }
            offset1 += 4L;
            offset2 += 4L;
        }
        if ((count & 2) != 0) {
            if (JavaInternals.unsafe.getShort(obj1, offset1) != JavaInternals.unsafe.getShort(obj2, offset2)) {
                return false;
            }
            offset1 += 2L;
            offset2 += 2L;
        }
        return (count & 1) == 0 || JavaInternals.unsafe.getByte(obj1, offset1) == JavaInternals.unsafe.getByte(obj2, offset2);
    }

    public static void copy(Object from, long fromOffset, Object to, long toOffset, int count) {
        while (count >= 8) {
            JavaInternals.unsafe.putLong(to, toOffset, JavaInternals.unsafe.getLong(from, fromOffset));
            fromOffset += 8L;
            toOffset += 8L;
            count -= 8;
        }
        if ((count & 4) != 0) {
            JavaInternals.unsafe.putInt(to, toOffset, JavaInternals.unsafe.getInt(from, fromOffset));
            fromOffset += 4L;
            toOffset += 4L;
        }
        if ((count & 2) != 0) {
            JavaInternals.unsafe.putShort(to, toOffset, JavaInternals.unsafe.getShort(from, fromOffset));
            fromOffset += 2L;
            toOffset += 2L;
        }
        if ((count & 1) != 0) {
            JavaInternals.unsafe.putByte(to, toOffset, JavaInternals.unsafe.getByte(from, fromOffset));
        }
    }
}

