/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.util.concurrent.ThreadLocalRandom;
import one.nio.mem.Malloc;
import one.nio.mem.MappedFile;
import one.nio.mem.OutOfMemoryException;
import one.nio.mgt.Management;

public class MallocMT
extends Malloc {
    public static final int DEFAULT_CONCURRENCY_LEVEL = 8;
    private Malloc[] segments;
    private long segmentSize;

    public MallocMT(long capacity, int concurrencyLevel) {
        super(capacity);
        this.initSegments(concurrencyLevel);
    }

    public MallocMT(long capacity) {
        this(capacity, 8);
    }

    public MallocMT(long base, long capacity, int concurrencyLevel) {
        super(base, capacity);
        this.initSegments(concurrencyLevel);
    }

    public MallocMT(long base, long capacity) {
        this(base, capacity, 8);
    }

    public MallocMT(MappedFile mmap, int concurrencyLevel) {
        super(mmap);
        this.initSegments(concurrencyLevel);
    }

    public MallocMT(MappedFile mmap) {
        this(mmap, 8);
    }

    public int segments() {
        return this.segments.length;
    }

    public Malloc segment(int index) {
        return this.segments[index];
    }

    public Malloc segmentFor(long n) {
        return this.segments[(int)n & this.segments.length - 1];
    }

    @Override
    public long getFreeMemory() {
        long result = 0L;
        for (Malloc segment : this.segments) {
            result += segment.getFreeMemory();
        }
        return result;
    }

    @Override
    public long malloc(int size) {
        int start;
        int alignedSize = Math.max(size, 16) + 15 & 0xFFFFFFF8;
        int bin = MallocMT.getBin(alignedSize);
        int adjustedSize = MallocMT.binSize(bin);
        int i = start = ThreadLocalRandom.current().nextInt(this.segments.length);
        do {
            long address;
            Malloc segment;
            if ((segment = this.segments[i]).getFreeMemory() < (long)alignedSize || (address = segment.mallocImpl(bin, adjustedSize)) == 0L) continue;
            return address;
        } while ((i = (i + 5) % this.segments.length) != start);
        throw new OutOfMemoryException("Failed to allocate " + size + " bytes");
    }

    private Malloc segmentByAddress(long address) {
        return this.segments[(int)((address - this.base) / this.segmentSize)];
    }

    @Override
    public void free(long address) {
        this.segmentByAddress(address).free(address);
    }

    @Override
    public int allocatedSize(long address) {
        return this.segmentByAddress(address).allocatedSize(address);
    }

    @Override
    public void verify() {
        for (Malloc segment : this.segments) {
            segment.verify();
        }
    }

    @Override
    void init() {
    }

    private void initSegments(int concurrencyLevel) {
        if (concurrencyLevel < 1) {
            throw new IllegalArgumentException("Nonpositive concurrencyLevel");
        }
        if (Integer.bitCount(concurrencyLevel) != 1) {
            throw new IllegalArgumentException("Only power of 2 concurrencyLevel's are supported");
        }
        if (this.capacity % (long)concurrencyLevel != 0L) {
            throw new IllegalArgumentException("capacity is not divisible by concurrencyLevel");
        }
        this.segments = new Malloc[concurrencyLevel];
        this.segmentSize = this.capacity / (long)concurrencyLevel;
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Malloc(this.base + (long)i * this.segmentSize, this.segmentSize);
        }
        Management.registerMXBean(this, "one.nio.mem:type=MallocMT,base=" + Long.toHexString(this.base));
    }
}

