/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import one.nio.net.NativeSslContext;
import one.nio.net.NativeSslSocket;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.os.Mem;

class NativeSocket
extends Socket {
    int fd;

    NativeSocket() throws IOException {
        this.fd = NativeSocket.socket0();
    }

    NativeSocket(int fd) {
        this.fd = fd;
    }

    @Override
    public final boolean isOpen() {
        return this.fd >= 0;
    }

    @Override
    public NativeSocket accept() throws IOException {
        return new NativeSocket(this.accept0());
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        byte[] buffer = new byte[24];
        return this.makeAddress(buffer, this.getsockname(buffer));
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        byte[] buffer = new byte[24];
        return this.makeAddress(buffer, this.getpeername(buffer));
    }

    private InetSocketAddress makeAddress(byte[] buffer, int length) {
        byte[] address;
        if (length == 8) {
            address = new byte[4];
            System.arraycopy(buffer, 4, address, 0, 4);
        } else if (length == 24) {
            address = new byte[16];
            System.arraycopy(buffer, 8, address, 0, 16);
        } else {
            return null;
        }
        int port = (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        try {
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public final Socket ssl(SslContext context) throws IOException {
        return new NativeSslSocket(this.fd, (NativeSslContext)context, false);
    }

    @Override
    public SslContext getSslContext() {
        return null;
    }

    @Override
    public final void connect(InetAddress address, int port) throws IOException {
        this.connect0(address.getAddress(), port);
    }

    @Override
    public final void bind(InetAddress address, int port, int backlog) throws IOException {
        this.bind0(address.getAddress(), port);
    }

    @Override
    public final native void listen(int var1) throws IOException;

    @Override
    public native void close();

    @Override
    public native int writeRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public native int write(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public native void writeFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public native int readRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public native int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public native void readFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        return this.sendFile0(Mem.getFD(file.getFD()), offset, count);
    }

    @Override
    public final native void setBlocking(boolean var1);

    @Override
    public final native void setTimeout(int var1);

    @Override
    public final native void setKeepAlive(boolean var1);

    @Override
    public final native void setNoDelay(boolean var1);

    @Override
    public final native void setTcpFastOpen(boolean var1);

    @Override
    public final native void setDeferAccept(boolean var1);

    @Override
    public final native void setReuseAddr(boolean var1);

    @Override
    public final native void setRecvBuffer(int var1);

    @Override
    public final native void setSendBuffer(int var1);

    @Override
    public final native byte[] getOption(int var1, int var2);

    @Override
    public final native boolean setOption(int var1, int var2, byte[] var3);

    static native int socket0() throws IOException;

    native void connect0(byte[] var1, int var2) throws IOException;

    native void bind0(byte[] var1, int var2) throws IOException;

    static native int socket1() throws IOException;

    native void connect1(String var1) throws IOException;

    native void bind1(String var1) throws IOException;

    native int accept0() throws IOException;

    native long sendFile0(int var1, long var2, long var4) throws IOException;

    native int getsockname(byte[] var1);

    native int getpeername(byte[] var1);
}

