/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import javax.net.ssl.SSLException;
import one.nio.net.Selector;
import one.nio.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Session
implements Closeable {
    protected static final Log log = LogFactory.getLog(Session.class);
    public static final int READABLE = 1;
    public static final int WRITEABLE = 4;
    public static final int CLOSING = 24;
    public static final int EVENT_MASK = 255;
    public static final int SSL = 256;
    public static final int ACTIVE = 0;
    public static final int IDLE = 1;
    public static final int STALE = 2;
    protected Socket socket;
    protected Selector selector;
    protected int slot;
    protected int events;
    protected int eventsToListen;
    protected boolean closing;
    protected QueueItem queueHead;
    protected volatile long lastAccessTime;

    public Session(Socket socket) {
        this(socket, 1);
    }

    public Session(Socket socket, int eventsToListen) {
        this.socket = socket;
        this.eventsToListen = eventsToListen;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public final String getRemoteHost() {
        InetSocketAddress address = this.socket.getRemoteAddress();
        return address == null ? null : address.getAddress().getHostAddress();
    }

    public final long lastAccessTime() {
        return this.lastAccessTime;
    }

    public boolean isSsl() {
        return this.socket.getSslContext() != null;
    }

    public int checkStatus(long currentTime, long keepAlive) {
        long lastAccessTime = this.lastAccessTime;
        if (lastAccessTime < currentTime - keepAlive && this.queueHead == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public synchronized void close() {
        QueueItem.releaseChain(this.queueHead);
        this.queueHead = null;
        if (this.socket.isOpen()) {
            this.closing = true;
            if (this.selector != null) {
                this.selector.unregister(this);
            }
            this.socket.close();
        }
    }

    public synchronized void scheduleClose() {
        if (this.queueHead == null) {
            this.close();
        } else {
            this.closing = true;
        }
    }

    public synchronized void getQueueStats(long[] stats) {
        int length = 0;
        long bytes = 0L;
        QueueItem item = this.queueHead;
        while (item != null) {
            ++length;
            bytes += (long)item.remaining();
            item = item.next;
        }
        stats[0] = length;
        stats[1] = bytes;
    }

    public void listen(int newEventsToListen) {
        if (newEventsToListen != this.eventsToListen) {
            this.eventsToListen = newEventsToListen;
            this.selector.listen(this, newEventsToListen & 0xFF);
        }
    }

    public int read(byte[] data, int offset, int count) throws IOException {
        int bytesRead = this.socket.read(data, offset, count);
        if (bytesRead >= 0) {
            this.listen(1);
            return bytesRead;
        }
        this.listen(260);
        return 0;
    }

    public int readRaw(long address, int count) throws IOException {
        int bytesRead = this.socket.readRaw(address, count, 0);
        if (bytesRead >= 0) {
            this.listen(1);
            return bytesRead;
        }
        this.listen(260);
        return 0;
    }

    public final void write(byte[] data, int offset, int count) throws IOException {
        this.write(data, offset, count, 0);
    }

    public final void write(byte[] data, int offset, int count, int flags) throws IOException {
        this.write(new ArrayQueueItem(data, offset, count, flags));
    }

    public final synchronized void write(QueueItem item) throws IOException {
        block6: {
            try {
                if (this.closing) {
                    throw new SocketException("Socket closed");
                }
                if (this.queueHead == null) {
                    while (item != null) {
                        int written = item.write(this.socket);
                        if (item.remaining() > 0) {
                            this.queueHead = item;
                            this.listen(written >= 0 ? 4 : 257);
                            break block6;
                        }
                        item.release();
                        item = item.next;
                    }
                    break block6;
                }
                this.queueHead.append(item);
            }
            catch (IOException e) {
                QueueItem.releaseChain(item);
                throw e;
            }
        }
    }

    protected void processRead(byte[] buffer) throws Exception {
        this.read(buffer, 0, buffer.length);
    }

    protected void processWrite() throws Exception {
        if (this.eventsToListen == 1 || this.eventsToListen == 260) {
            throw new IOException("Illegal subscription state: " + this.eventsToListen);
        }
        QueueItem item = this.queueHead;
        while (item != null) {
            int written = item.write(this.socket);
            if (item.remaining() > 0) {
                this.listen(written >= 0 ? 4 : 257);
                return;
            }
            item.release();
            this.queueHead = item = item.next;
        }
        if (this.closing) {
            this.close();
        } else {
            this.listen(1);
        }
    }

    public synchronized void process(byte[] buffer) throws Exception {
        this.lastAccessTime = Long.MAX_VALUE;
        if ((this.events & 0x18) != 0) {
            this.close();
        } else if (this.eventsToListen >= 256) {
            if ((this.events & 1) != 0) {
                this.processWrite();
            }
            if ((this.events & 4) != 0) {
                this.processRead(buffer);
            }
        } else {
            if ((this.events & 4) != 0) {
                this.processWrite();
            }
            if ((this.events & 1) != 0) {
                this.processRead(buffer);
            }
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void handleException(Throwable e) {
        if (e instanceof SocketException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connection closed: " + this.getRemoteHost()));
            }
        } else if (e instanceof SSLException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSL/TLS failure: " + this.getRemoteHost()));
            }
        } else {
            log.error((Object)("Cannot process session from " + this.getRemoteHost()), e);
        }
        this.close();
    }

    public static class ArrayQueueItem
    extends QueueItem {
        protected byte[] data;
        protected int offset;
        protected int count;
        protected int written;
        protected int flags;

        public ArrayQueueItem(byte[] data, int offset, int count, int flags) {
            this.data = data;
            this.offset = offset;
            this.count = count;
            this.flags = flags;
        }

        @Override
        public int remaining() {
            return this.count - this.written;
        }

        @Override
        public int write(Socket socket) throws IOException {
            int bytes = socket.write(this.data, this.offset + this.written, this.count - this.written, this.flags);
            if (bytes > 0) {
                this.written += bytes;
            }
            return bytes;
        }
    }

    public static abstract class QueueItem {
        protected QueueItem next;

        public QueueItem append(QueueItem next) {
            QueueItem tail = this;
            while (tail.next != null) {
                tail = tail.next;
            }
            tail.next = next;
            return this;
        }

        public int remaining() {
            return 0;
        }

        public void release() {
        }

        public static void releaseChain(QueueItem item) {
            while (item != null) {
                item.release();
                item = item.next;
            }
        }

        public abstract int write(Socket var1) throws IOException;
    }
}

