/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.SocketException;
import one.nio.net.ConnectionString;
import one.nio.net.Socket;
import one.nio.pool.SocketPool;
import one.nio.rpc.RemoteCall;
import one.nio.rpc.RpcPacket;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.DeserializeStream;
import one.nio.serial.Repository;
import one.nio.serial.SerializeStream;
import one.nio.serial.Serializer;
import one.nio.serial.SerializerNotFoundException;

public class RpcClient
extends SocketPool
implements InvocationHandler {
    protected final Object[] uidLocks = new Object[64];

    public RpcClient(ConnectionString conn) {
        super(conn);
        for (int i = 0; i < this.uidLocks.length; ++i) {
            this.uidLocks[i] = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object request) throws Exception {
        Object response;
        byte[] buffer = this.invokeRaw(request);
        while (true) {
            try {
                response = new DeserializeStream(buffer).readObject();
            }
            catch (SerializerNotFoundException e) {
                long uid = e.getUid();
                Object object = this.uidLockFor(uid);
                synchronized (object) {
                    if (!Repository.hasSerializer(uid)) {
                        Repository.provideSerializer(this.requestSerializer(uid));
                    }
                    continue;
                }
            }
            if (!(response instanceof Exception)) {
                return response;
            }
            if (!(response instanceof SerializerNotFoundException)) break;
            long uid = ((SerializerNotFoundException)response).getUid();
            this.provideSerializer(Repository.requestSerializer(uid));
            buffer = this.invokeRaw(request);
        }
        throw (Exception)response;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Exception {
        return this.invoke(new RemoteCall(method, args));
    }

    protected Object uidLockFor(long uid) {
        return this.uidLocks[(int)uid & this.uidLocks.length - 1];
    }

    protected void provideSerializer(Serializer serializer) throws Exception {
        this.invokeServiceRequest(new RemoteCall(Repository.provide, serializer));
    }

    protected Serializer requestSerializer(long uid) throws Exception {
        return (Serializer)this.invokeServiceRequest(new RemoteCall(Repository.request, uid));
    }

    protected Object invokeServiceRequest(Object request) throws Exception {
        byte[] rawResponse = this.invokeRaw(request);
        Object response = new DeserializeStream(rawResponse).readObject();
        if (response instanceof Exception) {
            throw (Exception)response;
        }
        return response;
    }

    private byte[] invokeRaw(Object request) throws Exception {
        byte[] buffer = this.serialize(request);
        Socket socket = (Socket)this.borrowObject();
        try {
            try {
                this.sendRequest(socket, buffer);
            }
            catch (SocketException e) {
                this.destroyObject(socket);
                socket = this.createObject();
                this.sendRequest(socket, buffer);
            }
            int responseSize = RpcPacket.getSize(buffer, socket);
            if (responseSize > 4) {
                buffer = new byte[responseSize];
            }
            socket.readFully(buffer, 0, responseSize);
            this.returnObject(socket);
            return buffer;
        }
        catch (Exception e) {
            this.invalidateObject(socket);
            throw e;
        }
    }

    private byte[] serialize(Object request) throws IOException {
        CalcSizeStream css = new CalcSizeStream();
        css.writeObject(request);
        int requestSize = css.count();
        byte[] buffer = new byte[requestSize + 4];
        DataStream ds = css.hasCycles() ? new SerializeStream(buffer) : new DataStream(buffer);
        ds.writeInt(requestSize);
        ds.writeObject(request);
        return buffer;
    }

    private void sendRequest(Socket socket, byte[] buffer) throws IOException {
        socket.writeFully(buffer, 0, buffer.length);
        socket.readFully(buffer, 0, 4);
    }
}

