/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc;

import java.io.IOException;
import one.nio.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RpcPacket {
    private static final Log log = LogFactory.getLog(RpcPacket.class);
    private static final int WARN_PACKET_SIZE = 0x400000;
    private static final int ERROR_PACKET_SIZE = 0x8000000;

    RpcPacket() {
    }

    static int getSize(byte[] buffer, Socket socket) throws IOException {
        int size = buffer[0] << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        if (size < 0 || size >= 0x8000000) {
            throw new IOException("Invalid RPC packet from " + socket.getRemoteAddress());
        }
        if (size >= 0x400000) {
            log.warn((Object)("RPC packet from " + socket.getRemoteAddress() + " is too large: " + size));
        }
        return size;
    }
}

