/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.RejectedExecutionException;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.rpc.RemoteCall;
import one.nio.rpc.RpcPacket;
import one.nio.rpc.RpcServer;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.DeserializeStream;
import one.nio.serial.SerializeStream;
import one.nio.serial.SerializerNotFoundException;

public class RpcSession<S, M>
extends Session {
    private static final int BUFFER_SIZE = 8000;
    protected final RpcServer<S> server;
    protected final InetSocketAddress peer;
    protected byte[] buffer;
    protected int bytesRead;
    protected int requestSize;
    protected long requestStartTime;

    public RpcSession(Socket socket, RpcServer<S> server) {
        super(socket);
        this.server = server;
        this.peer = socket.getRemoteAddress();
        this.buffer = new byte[8000];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRead(byte[] unusedBuffer) throws Exception {
        Object request;
        byte[] buffer = this.buffer;
        int bytesRead = this.bytesRead;
        int requestSize = this.requestSize;
        if (requestSize == 0) {
            if ((bytesRead += super.read(buffer, bytesRead, 4 - bytesRead)) < 4) {
                this.bytesRead = bytesRead;
                return;
            }
            bytesRead = 0;
            this.requestSize = RpcPacket.getSize(buffer, this.socket);
            requestSize = this.requestSize;
            if (requestSize > buffer.length) {
                buffer = this.buffer = new byte[requestSize];
            }
            this.requestStartTime = this.selector.lastWakeupTime();
        }
        if ((bytesRead += super.read(buffer, bytesRead, requestSize - bytesRead)) < requestSize) {
            this.bytesRead = bytesRead;
            return;
        }
        M meta = this.onRequestRead();
        this.bytesRead = 0;
        this.requestSize = 0;
        try {
            request = new DeserializeStream(buffer, requestSize).readObject();
        }
        catch (SerializerNotFoundException e) {
            this.writeResponse(e);
            return;
        }
        catch (Exception e) {
            this.handleDeserializationException(e);
            this.server.incRequestsRejected();
            return;
        }
        finally {
            if (requestSize > 8000) {
                this.buffer = new byte[8000];
            }
        }
        if (this.server.getWorkersUsed()) {
            try {
                this.server.asyncExecute(new AsyncRequest(request, meta));
                this.server.incRequestsProcessed();
            }
            catch (RejectedExecutionException e) {
                this.handleRejectedExecution(e, request);
                this.server.incRequestsRejected();
            }
        } else {
            this.invoke(request, meta);
            this.server.incRequestsProcessed();
        }
    }

    protected M onRequestRead() {
        return null;
    }

    protected int writeResponse(Object response) throws IOException {
        CalcSizeStream css = new CalcSizeStream();
        css.writeObject(response);
        int responseSize = css.count();
        byte[] buffer = new byte[responseSize + 4];
        DataStream ds = css.hasCycles() ? new SerializeStream(buffer) : new DataStream(buffer);
        ds.writeInt(responseSize);
        ds.writeObject(response);
        super.write(buffer, 0, buffer.length);
        return responseSize;
    }

    protected void invoke(Object request, M meta) throws Exception {
        RemoteCall remoteCall = (RemoteCall)request;
        Object response = remoteCall.method().invoke(this.server.service, remoteCall.args());
        this.writeResponse(response);
    }

    protected void handleDeserializationException(Exception e) throws IOException {
        this.writeResponse(e);
        log.error((Object)("Cannot deserialize request from " + this.getRemoteHost()), (Throwable)e);
    }

    protected void handleRejectedExecution(RejectedExecutionException e, Object request) throws IOException {
        this.writeResponse(e);
        log.error((Object)("RejectedExecutionException for request: " + request));
    }

    private class AsyncRequest
    implements Runnable {
        private final Object request;
        private final M meta;

        AsyncRequest(Object request, M meta) {
            this.request = request;
            this.meta = meta;
        }

        @Override
        public void run() {
            try {
                RpcSession.this.invoke(this.request, this.meta);
            }
            catch (Throwable e) {
                RpcSession.this.handleException(e);
            }
        }
    }
}

