/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.NotSerializableException;
import java.nio.LongBuffer;
import java.util.BitSet;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Serializer;

class BitSetSerializer
extends Serializer<BitSet> {
    BitSetSerializer() {
        super(BitSet.class);
    }

    @Override
    public void calcSize(BitSet obj, CalcSizeStream css) {
        int wordCount = (obj.length() + 63) / 64;
        css.count += 4 + wordCount * 8;
    }

    @Override
    public void write(BitSet obj, DataStream out) throws IOException {
        long[] words = obj.toLongArray();
        out.writeInt(words.length);
        for (long word : words) {
            out.writeLong(word);
        }
    }

    @Override
    public BitSet read(DataStream in) throws IOException {
        int wordCount = in.readInt();
        LongBuffer buf = in.byteBuffer(wordCount * 8).asLongBuffer();
        BitSet result = BitSet.valueOf(buf);
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(in.readInt() * 8);
    }

    @Override
    public void toJson(BitSet obj, StringBuilder builder) throws NotSerializableException {
        throw new NotSerializableException(this.cls.getName());
    }
}

