/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Serializer;
import one.nio.util.Base64;

class ByteArraySerializer
extends Serializer<byte[]> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public void calcSize(byte[] obj, CalcSizeStream css) {
        css.count += 4 + obj.length;
    }

    @Override
    public void write(byte[] obj, DataStream out) throws IOException {
        out.writeInt(obj.length);
        out.write(obj);
    }

    @Override
    public byte[] read(DataStream in) throws IOException {
        byte[] result;
        int length = in.readInt();
        if (length > 0) {
            result = new byte[length];
            in.readFully(result);
        } else {
            result = EMPTY_BYTE_ARRAY;
        }
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(in.readInt());
    }

    @Override
    public void toJson(byte[] obj, StringBuilder builder) {
        builder.append('\"').append(Base64.encodeToChars(obj)).append('\"');
    }
}

