/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Serializer;

class ByteSerializer
extends Serializer<Byte> {
    ByteSerializer() {
        super(Byte.class);
    }

    @Override
    public void calcSize(Byte obj, CalcSizeStream css) {
        ++css.count;
    }

    @Override
    public void write(Byte v, DataStream out) throws IOException {
        out.writeByte(v.byteValue());
    }

    @Override
    public Byte read(DataStream in) throws IOException {
        Byte result = in.readByte();
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(1);
    }

    @Override
    public void toJson(Byte obj, StringBuilder builder) {
        builder.append(obj.byteValue());
    }
}

