/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.Serializer;

class CharacterSerializer
extends Serializer<Character> {
    CharacterSerializer() {
        super(Character.class);
    }

    @Override
    public void calcSize(Character obj, CalcSizeStream css) {
        css.count += 2;
    }

    @Override
    public void write(Character v, DataStream out) throws IOException {
        out.writeChar(v.charValue());
    }

    @Override
    public Character read(DataStream in) throws IOException {
        Character result = Character.valueOf(in.readChar());
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(2);
    }

    @Override
    public void toJson(Character v, StringBuilder builder) {
        Json.appendChar(builder, v.charValue());
    }
}

