/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import one.nio.mem.DirectMemory;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;
import one.nio.util.Utf8;

public class DataStream
implements ObjectInput,
ObjectOutput {
    protected static final byte REF_NULL = -1;
    protected static final byte REF_RECURSIVE = -2;
    protected static final byte REF_RECURSIVE2 = -3;
    protected static final byte REF_EMBEDDED = -4;
    protected byte[] array;
    protected long address;
    protected long limit;
    protected long offset;

    public DataStream(int capacity) {
        this(new byte[capacity], JavaInternals.byteArrayOffset, capacity);
    }

    public DataStream(byte[] array) {
        this(array, JavaInternals.byteArrayOffset, array.length);
    }

    public DataStream(long address, long length) {
        this(null, address, length);
    }

    protected DataStream(byte[] array, long address, long length) {
        this.array = array;
        this.address = address;
        this.limit = address + length;
        this.offset = address;
    }

    public byte[] array() {
        return this.array;
    }

    public long address() {
        return this.address;
    }

    public int count() {
        return (int)(this.offset - this.address);
    }

    @Override
    public void write(int b) {
        long offset = this.alloc(1);
        JavaInternals.unsafe.putByte(this.array, offset, (byte)b);
    }

    @Override
    public void write(byte[] b) {
        long offset = this.alloc(b.length);
        JavaInternals.unsafe.copyMemory(b, JavaInternals.byteArrayOffset, this.array, offset, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        long offset = this.alloc(len);
        JavaInternals.unsafe.copyMemory(b, JavaInternals.byteArrayOffset + (long)off, this.array, offset, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        long offset = this.alloc(1);
        JavaInternals.unsafe.putBoolean(this.array, offset, v);
    }

    @Override
    public void writeByte(int v) {
        long offset = this.alloc(1);
        JavaInternals.unsafe.putByte(this.array, offset, (byte)v);
    }

    @Override
    public void writeShort(int v) {
        long offset = this.alloc(2);
        JavaInternals.unsafe.putShort(this.array, offset, Short.reverseBytes((short)v));
    }

    @Override
    public void writeChar(int v) {
        long offset = this.alloc(2);
        JavaInternals.unsafe.putChar(this.array, offset, Character.reverseBytes((char)v));
    }

    @Override
    public void writeInt(int v) {
        long offset = this.alloc(4);
        JavaInternals.unsafe.putInt(this.array, offset, Integer.reverseBytes(v));
    }

    @Override
    public void writeLong(long v) {
        long offset = this.alloc(8);
        JavaInternals.unsafe.putLong(this.array, offset, Long.reverseBytes(v));
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void writeBytes(String s) {
        int length = s.length();
        long offset = this.alloc(length);
        for (int i = 0; i < length; ++i) {
            JavaInternals.unsafe.putByte(this.array, offset++, (byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) {
        int length = s.length();
        long offset = this.alloc(length * 2);
        for (int i = 0; i < length; ++i) {
            JavaInternals.unsafe.putChar(this.array, offset, Character.reverseBytes(s.charAt(i)));
            offset += 2L;
        }
    }

    @Override
    public void writeUTF(String s) {
        int utfLength = Utf8.length(s);
        if (utfLength <= Short.MAX_VALUE) {
            this.writeShort(utfLength);
        } else {
            this.writeInt(utfLength | Integer.MIN_VALUE);
        }
        long offset = this.alloc(utfLength);
        Utf8.write(s, (Object)this.array, offset);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(-1);
        } else {
            Serializer<?> serializer = Repository.get(obj.getClass());
            if (serializer.uid < 0L) {
                this.writeByte((byte)serializer.uid);
            } else {
                this.writeLong(serializer.uid);
            }
            serializer.write(obj, this);
        }
    }

    public void writeFrom(long address, int len) {
        long offset = this.alloc(len);
        JavaInternals.unsafe.copyMemory(null, address, this.array, offset, len);
    }

    @Override
    public int read() {
        return JavaInternals.unsafe.getByte(this.array, this.alloc(1));
    }

    @Override
    public int read(byte[] b) {
        this.readFully(b);
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        this.readFully(b, off, len);
        return len;
    }

    @Override
    public void readFully(byte[] b) {
        JavaInternals.unsafe.copyMemory(this.array, this.alloc(b.length), b, JavaInternals.byteArrayOffset, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        JavaInternals.unsafe.copyMemory(this.array, this.alloc(len), b, JavaInternals.byteArrayOffset + (long)off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.alloc((int)n);
        return n;
    }

    @Override
    public int skipBytes(int n) {
        this.alloc(n);
        return n;
    }

    @Override
    public boolean readBoolean() {
        return JavaInternals.unsafe.getBoolean(this.array, this.alloc(1));
    }

    @Override
    public byte readByte() {
        return JavaInternals.unsafe.getByte(this.array, this.alloc(1));
    }

    @Override
    public int readUnsignedByte() {
        return JavaInternals.unsafe.getByte(this.array, this.alloc(1)) & 0xFF;
    }

    @Override
    public short readShort() {
        return Short.reverseBytes(JavaInternals.unsafe.getShort(this.array, this.alloc(2)));
    }

    @Override
    public int readUnsignedShort() {
        return Short.reverseBytes(JavaInternals.unsafe.getShort(this.array, this.alloc(2))) & 0xFFFF;
    }

    @Override
    public char readChar() {
        return Character.reverseBytes(JavaInternals.unsafe.getChar(this.array, this.alloc(2)));
    }

    @Override
    public int readInt() {
        return Integer.reverseBytes(JavaInternals.unsafe.getInt(this.array, this.alloc(4)));
    }

    @Override
    public long readLong() {
        return Long.reverseBytes(JavaInternals.unsafe.getLong(this.array, this.alloc(8)));
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        int length = this.readUnsignedShort();
        if (length == 0) {
            return "";
        }
        if (length > Short.MAX_VALUE) {
            length = (length & Short.MAX_VALUE) << 16 | this.readUnsignedShort();
        }
        return Utf8.read((Object)this.array, this.alloc(length), length);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        Serializer serializer;
        byte b = this.readByte();
        if (b >= 0) {
            --this.offset;
            serializer = Repository.requestSerializer(this.readLong());
        } else {
            if (b == -1) {
                return null;
            }
            serializer = Repository.requestBootstrapSerializer(b);
        }
        return serializer.read(this);
    }

    public void readTo(long address, int len) {
        JavaInternals.unsafe.copyMemory(this.array, this.alloc(len), null, address, len);
    }

    public ByteBuffer byteBuffer(int len) {
        long offset = this.alloc(len);
        if (this.array != null) {
            return ByteBuffer.wrap(this.array, (int)(offset - JavaInternals.byteArrayOffset), len);
        }
        return DirectMemory.wrap(offset, len);
    }

    @Override
    public int available() {
        return (int)(this.limit - this.offset);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public void register(Object obj) {
    }

    protected long alloc(int size) {
        long currentOffset = this.offset;
        this.offset = currentOffset + (long)size;
        if (this.offset > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return currentOffset;
    }
}

