/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.util.Arrays;
import one.nio.serial.DataStream;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;

public class DeserializeStream
extends DataStream {
    static final int INITIAL_CAPACITY = 24;
    protected Object[] context = new Object[24];
    protected int contextSize;

    public DeserializeStream(byte[] array) {
        super(array);
    }

    public DeserializeStream(byte[] array, int length) {
        super(array, JavaInternals.byteArrayOffset, length);
    }

    public DeserializeStream(long address, long length) {
        super(address, length);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        Serializer serializer;
        byte b = this.readByte();
        if (b >= 0) {
            --this.offset;
            serializer = Repository.requestSerializer(this.readLong());
        } else {
            switch (b) {
                case -1: {
                    return null;
                }
                case -2: {
                    return this.context[this.readUnsignedShort() + 1];
                }
                case -3: {
                    return this.context[this.readInt() + 1];
                }
                case -4: {
                    serializer = (Serializer)this.readObject();
                    break;
                }
                default: {
                    serializer = Repository.requestBootstrapSerializer(b);
                }
            }
        }
        if (++this.contextSize >= this.context.length) {
            this.context = Arrays.copyOf(this.context, this.context.length * 2);
        }
        return serializer.read(this);
    }

    @Override
    public void close() {
        this.context = null;
    }

    @Override
    public void register(Object obj) {
        this.context[this.contextSize] = obj;
    }
}

