/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.gen.BytecodeGenerator;
import one.nio.mgt.Management;
import one.nio.serial.ArrayListSerializer;
import one.nio.serial.BitSetSerializer;
import one.nio.serial.BooleanArraySerializer;
import one.nio.serial.BooleanSerializer;
import one.nio.serial.ByteArraySerializer;
import one.nio.serial.ByteSerializer;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.CharacterArraySerializer;
import one.nio.serial.CharacterSerializer;
import one.nio.serial.ClassSerializer;
import one.nio.serial.CollectionSerializer;
import one.nio.serial.DateSerializer;
import one.nio.serial.DeserializeStream;
import one.nio.serial.DoubleArraySerializer;
import one.nio.serial.DoubleSerializer;
import one.nio.serial.EnumSerializer;
import one.nio.serial.ExternalizableSerializer;
import one.nio.serial.FloatArraySerializer;
import one.nio.serial.FloatSerializer;
import one.nio.serial.GeneratedSerializer;
import one.nio.serial.HashMapSerializer;
import one.nio.serial.IntegerArraySerializer;
import one.nio.serial.IntegerSerializer;
import one.nio.serial.InvalidSerializer;
import one.nio.serial.LongArraySerializer;
import one.nio.serial.LongSerializer;
import one.nio.serial.MapSerializer;
import one.nio.serial.MethodSerializer;
import one.nio.serial.ObjectArraySerializer;
import one.nio.serial.Origin;
import one.nio.serial.RemoteCallSerializer;
import one.nio.serial.Renamed;
import one.nio.serial.SerializationMXBeanImpl;
import one.nio.serial.SerializeStream;
import one.nio.serial.Serializer;
import one.nio.serial.SerializerNotFoundException;
import one.nio.serial.SerializerSerializer;
import one.nio.serial.ShortArraySerializer;
import one.nio.serial.ShortSerializer;
import one.nio.serial.StringSerializer;
import one.nio.serial.TimestampSerializer;
import one.nio.util.Base64;
import one.nio.util.JavaInternals;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Repository {
    public static final Log log = LogFactory.getLog(Repository.class);
    static final IdentityHashMap<Class, Serializer> classMap = new IdentityHashMap(128);
    static final HashMap<Long, Serializer> uidMap = new HashMap(128);
    static final HashMap<Method, MethodSerializer> methodMap = new HashMap();
    static final Serializer[] bootstrapSerializers = new Serializer[128];
    static final IdentityHashMap<Class, Integer> serializationOptions = new IdentityHashMap();
    static final HashMap<String, Class> renamedClasses = new HashMap();
    static final AtomicInteger anonymousClasses = new AtomicInteger();
    static final int ENUM = 16384;
    public static final MethodSerializer provide = Repository.registerMethod(JavaInternals.getMethod(Repository.class, "provideSerializer", Serializer.class));
    public static final MethodSerializer request = Repository.registerMethod(JavaInternals.getMethod(Repository.class, "requestSerializer", Long.TYPE));
    public static final int SKIP_READ_OBJECT = 1;
    public static final int SKIP_WRITE_OBJECT = 2;
    public static final int SKIP_CUSTOM_SERIALIZATION = 3;
    public static final int INLINE = 4;
    public static final int FIELD_SERIALIZATION = 8;
    public static final int ARRAY_STUBS = 1;
    public static final int COLLECTION_STUBS = 2;
    public static final int MAP_STUBS = 4;
    public static final int ENUM_STUBS = 8;
    public static final int CUSTOM_STUBS = 16;
    public static final int DEFAULT_OPTIONS = 31;
    private static long nextBootstrapUid = -10L;
    private static int options = Integer.getInteger("one.nio.serial.options", 31);

    private static void addBootstrap(Serializer serializer) {
        serializer.uid = nextBootstrapUid--;
        Repository.provideSerializer(serializer);
    }

    private static void addOptionalBootstrap(String className) {
        try {
            Repository.addBootstrap(Repository.generateFor(Class.forName(className)));
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Missing optional bootstrap class: " + className));
            --nextBootstrapUid;
        }
    }

    public static <T> Serializer<T> get(Class<T> cls) {
        Serializer result = classMap.get(cls);
        return result != null ? result : Repository.generateFor(cls);
    }

    public static MethodSerializer get(Method method) {
        return methodMap.get(method);
    }

    public static MethodSerializer registerMethod(Method method) {
        MethodSerializer result = methodMap.get(method);
        if (result == null) {
            result = new MethodSerializer(method);
            Repository.provideSerializer(result);
        }
        return result;
    }

    public static boolean preload(Class ... classes) {
        for (Class cls : classes) {
            Repository.get(cls);
        }
        return true;
    }

    public static boolean hasSerializer(long uid) {
        return uidMap.containsKey(uid);
    }

    public static Serializer requestSerializer(long uid) throws SerializerNotFoundException {
        Serializer result = uidMap.get(uid);
        if (result != null) {
            return result;
        }
        throw new SerializerNotFoundException(uid);
    }

    public static Serializer requestBootstrapSerializer(byte uid) {
        return bootstrapSerializers[128 + uid];
    }

    public static synchronized void provideSerializer(Serializer serializer) {
        Serializer oldSerializer = uidMap.put(serializer.uid, serializer);
        if (oldSerializer != null && oldSerializer.cls != serializer.cls) {
            throw new IllegalStateException("UID collision: " + serializer.descriptor + " overwrites " + oldSerializer.descriptor);
        }
        if (serializer.uid < 0L) {
            Repository.bootstrapSerializers[128 + (int)serializer.uid] = serializer;
        }
        if (serializer.origin != Origin.EXTERNAL) {
            if (serializer instanceof MethodSerializer) {
                MethodSerializer methodSerializer = (MethodSerializer)serializer;
                methodMap.put(methodSerializer.method, methodSerializer);
            } else {
                classMap.put(serializer.cls, serializer);
            }
        }
    }

    public static void provideSerializer(String base64) {
        try {
            byte[] serialForm = Base64.decodeFromChars(base64.toCharArray());
            Repository.provideSerializer((Serializer)Serializer.deserialize(serialForm));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setOptions(String className, int options) {
        try {
            Class<?> cls = Class.forName(className, false, BytecodeGenerator.INSTANCE);
            Repository.setOptions(cls, options);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static synchronized void setOptions(Class cls, int options) {
        serializationOptions.put(cls, options);
        classMap.remove(cls);
    }

    public static boolean hasOptions(Class cls, int options) {
        Integer value = serializationOptions.get(cls);
        return value != null && (value & options) == options;
    }

    public static void setOptions(int options) {
        Repository.options = options;
    }

    public static int getOptions() {
        return options;
    }

    public static byte[] saveSnapshot() throws IOException {
        Serializer[] serializers = Repository.getSerializers(uidMap);
        CalcSizeStream css = new CalcSizeStream();
        for (Serializer serializer : serializers) {
            if (serializer.uid < 0L) continue;
            css.writeObject(serializer);
        }
        byte[] snapshot = new byte[css.count()];
        SerializeStream ss = new SerializeStream(snapshot);
        for (Serializer serializer : serializers) {
            if (serializer.uid < 0L) continue;
            ss.writeObject(serializer);
        }
        return snapshot;
    }

    public static void saveSnapshot(String fileName) throws IOException {
        byte[] snapshot = Repository.saveSnapshot();
        Files.write(Paths.get(fileName, new String[0]), snapshot, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static int loadSnapshot(byte[] snapshot) throws IOException, ClassNotFoundException {
        int count = 0;
        DeserializeStream ds = new DeserializeStream(snapshot);
        while (ds.available() > 0) {
            Repository.provideSerializer((Serializer)ds.readObject());
            ++count;
        }
        return count;
    }

    public static int loadSnapshot(String fileName) throws IOException, ClassNotFoundException {
        byte[] snapshot = Files.readAllBytes(Paths.get(fileName, new String[0]));
        return Repository.loadSnapshot(snapshot);
    }

    private static synchronized Serializer[] getSerializers(Map<?, ? extends Serializer> map) {
        return map.values().toArray(new Serializer[0]);
    }

    private static synchronized Serializer generateFor(Class<?> cls) {
        Serializer serializer = classMap.get(cls);
        if (serializer == null) {
            Renamed renamed;
            if (cls.isArray()) {
                Repository.get(cls.getComponentType());
                serializer = new ObjectArraySerializer(cls);
            } else if ((cls.getModifiers() & 0x4000) != 0) {
                if (cls.getSuperclass() != Enum.class) {
                    serializer = Repository.get(cls.getSuperclass());
                    classMap.put(cls, serializer);
                    return serializer;
                }
                serializer = new EnumSerializer(cls);
            } else {
                serializer = Externalizable.class.isAssignableFrom(cls) ? (Serializer.class.isAssignableFrom(cls) ? new SerializerSerializer(cls) : new ExternalizableSerializer(cls)) : (Collection.class.isAssignableFrom(cls) && !Repository.hasOptions(cls, 8) ? new CollectionSerializer(cls) : (Map.class.isAssignableFrom(cls) && !Repository.hasOptions(cls, 8) ? new MapSerializer(cls) : (Serializable.class.isAssignableFrom(cls) ? new GeneratedSerializer(cls) : new InvalidSerializer(cls))));
            }
            serializer.generateUid();
            Repository.provideSerializer(serializer);
            if (cls.isAnonymousClass()) {
                log.warn((Object)("Trying to serialize anonymous class: " + cls.getName()));
                anonymousClasses.incrementAndGet();
            }
            if ((renamed = cls.getAnnotation(Renamed.class)) != null) {
                renamedClasses.put(renamed.from(), cls);
            }
        }
        return serializer;
    }

    static {
        Repository.addBootstrap(new IntegerSerializer());
        Repository.addBootstrap(new LongSerializer());
        Repository.addBootstrap(new BooleanSerializer());
        Repository.addBootstrap(new ByteSerializer());
        Repository.addBootstrap(new ShortSerializer());
        Repository.addBootstrap(new CharacterSerializer());
        Repository.addBootstrap(new FloatSerializer());
        Repository.addBootstrap(new DoubleSerializer());
        Repository.addBootstrap(new StringSerializer());
        Repository.addBootstrap(new DateSerializer());
        Repository.addBootstrap(new ClassSerializer());
        Repository.addBootstrap(new BitSetSerializer());
        Repository.addBootstrap(new BooleanArraySerializer());
        Repository.addBootstrap(new ByteArraySerializer());
        Repository.addBootstrap(new ShortArraySerializer());
        Repository.addBootstrap(new CharacterArraySerializer());
        Repository.addBootstrap(new IntegerArraySerializer());
        Repository.addBootstrap(new LongArraySerializer());
        Repository.addBootstrap(new FloatArraySerializer());
        Repository.addBootstrap(new DoubleArraySerializer());
        Repository.addBootstrap(new ObjectArraySerializer(Object[].class));
        Repository.addBootstrap(new ObjectArraySerializer(String[].class));
        Repository.addBootstrap(new ObjectArraySerializer(Class[].class));
        Repository.addBootstrap(new ObjectArraySerializer(Long[].class));
        Repository.addBootstrap(new ArrayListSerializer());
        Repository.addBootstrap(new CollectionSerializer(LinkedList.class));
        Repository.addBootstrap(new CollectionSerializer(Vector.class));
        Repository.addBootstrap(new CollectionSerializer(HashSet.class));
        Repository.addBootstrap(new CollectionSerializer(TreeSet.class));
        Repository.addBootstrap(new CollectionSerializer(LinkedHashSet.class));
        Repository.addBootstrap(new HashMapSerializer());
        Repository.addBootstrap(new MapSerializer(TreeMap.class));
        Repository.addBootstrap(new MapSerializer(LinkedHashMap.class));
        Repository.addBootstrap(new MapSerializer(Hashtable.class));
        Repository.addBootstrap(new MapSerializer(IdentityHashMap.class));
        Repository.addBootstrap(new MapSerializer(ConcurrentHashMap.class));
        Repository.addBootstrap(new SerializerSerializer(ObjectArraySerializer.class));
        Repository.addBootstrap(new SerializerSerializer(EnumSerializer.class));
        Repository.addBootstrap(new SerializerSerializer(CollectionSerializer.class));
        Repository.addBootstrap(new SerializerSerializer(MapSerializer.class));
        Repository.addBootstrap(new SerializerSerializer(ExternalizableSerializer.class));
        Repository.addBootstrap(new SerializerSerializer(GeneratedSerializer.class));
        Repository.addBootstrap(new ExternalizableSerializer(SerializerNotFoundException.class));
        Repository.addOptionalBootstrap("one.app.remote.reflect.MethodId");
        Repository.addOptionalBootstrap("one.app.remote.comp.RemoteMethodCallRequest");
        Repository.addBootstrap(new TimestampSerializer());
        Repository.addBootstrap(new RemoteCallSerializer());
        Repository.addBootstrap(new SerializerSerializer(MethodSerializer.class));
        Repository.setOptions(InetAddress.class, 3);
        Repository.setOptions(InetSocketAddress.class, 3);
        Repository.setOptions(StringBuilder.class, 3);
        Repository.setOptions(StringBuffer.class, 3);
        Repository.setOptions(BigInteger.class, 3);
        Repository.setOptions("java.net.InetAddress$InetAddressHolder", 4);
        Repository.setOptions("java.net.InetSocketAddress$InetSocketAddressHolder", 4);
        Management.registerMXBean(new SerializationMXBeanImpl(), "one.nio.serial:type=Serialization");
    }
}

