/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

class SerializationContext {
    private static final int INITIAL_CAPACITY = 64;
    private Object first;
    private Object[] keys;
    private int[] values;
    private int size;
    private int threshold;

    SerializationContext() {
    }

    public int put(Object obj) {
        if (this.first == null) {
            this.first = obj;
            return -1;
        }
        Object[] keys = this.keys;
        if (keys == null) {
            keys = this.init();
        }
        int mask = keys.length - 1;
        int i = System.identityHashCode(obj) & mask;
        while (keys[i] != null) {
            if (keys[i] == obj) {
                return this.values[i];
            }
            i = i + 1 & mask;
        }
        keys[i] = obj;
        this.values[i] = this.size++;
        if (this.size >= this.threshold) {
            this.resize();
        }
        return -1;
    }

    public int indexOf(Object obj) {
        if (this.first == null) {
            return -1;
        }
        Object[] keys = this.keys;
        if (keys == null) {
            keys = this.init();
        }
        int mask = keys.length - 1;
        int i = System.identityHashCode(obj) & mask;
        while (keys[i] != null) {
            if (keys[i] == obj) {
                return this.values[i];
            }
            i = i + 1 & mask;
        }
        return -1;
    }

    private Object[] init() {
        this.keys = new Object[64];
        this.values = new int[64];
        this.size = 1;
        this.threshold = 42;
        this.keys[System.identityHashCode((Object)this.first) & 0x3F] = this.first;
        return this.keys;
    }

    private void resize() {
        Object[] keys = this.keys;
        int[] values = this.values;
        int newLength = keys.length * 2;
        Object[] newKeys = new Object[newLength];
        int[] newValues = new int[newLength];
        int mask = newLength - 1;
        for (int i = 0; i < keys.length; ++i) {
            Object obj = keys[i];
            if (obj == null) continue;
            int j = System.identityHashCode(obj) & mask;
            while (newKeys[j] != null) {
                j = j + 1 & mask;
            }
            newKeys[j] = obj;
            newValues[j] = values[i];
        }
        this.keys = newKeys;
        this.values = newValues;
        this.threshold = newLength * 2 / 3;
    }
}

