/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import one.nio.config.Config;
import one.nio.config.Converter;
import one.nio.net.ConnectionString;
import one.nio.net.SslConfig;
import one.nio.server.AcceptorConfig;

@Config
public class ServerConfig {
    public AcceptorConfig[] acceptors;
    public int selectors;
    public boolean affinity;
    public int minWorkers;
    public int maxWorkers;
    @Converter(method="time")
    public int queueTime;
    @Converter(method="time")
    public int keepAlive;
    public int threadPriority = 5;

    @Deprecated
    public static ServerConfig from(String conn) {
        return ServerConfig.from(new ConnectionString(conn));
    }

    @Deprecated
    public static ServerConfig from(ConnectionString conn) {
        AcceptorConfig ac = new AcceptorConfig();
        ac.address = conn.getHost();
        ac.port = conn.getPort();
        ac.recvBuf = conn.getIntParam("recvBuf", 0);
        ac.sendBuf = conn.getIntParam("sendBuf", 0);
        ac.backlog = conn.getIntParam("backlog", 128);
        if ("ssl".equals(conn.getProtocol())) {
            ac.ssl = SslConfig.from(System.getProperties());
        }
        ServerConfig sc = new ServerConfig();
        sc.acceptors = new AcceptorConfig[]{ac};
        sc.selectors = conn.getIntParam("selectors", 0);
        sc.minWorkers = conn.getIntParam("minWorkers", 0);
        sc.maxWorkers = conn.getIntParam("maxWorkers", 0);
        sc.queueTime = conn.getIntParam("queueTime", 0) / 1000;
        sc.threadPriority = conn.getIntParam("threadPriority", 5);
        return sc;
    }
}

