/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class WorkerPool
extends ThreadPoolExecutor
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(WorkerPool.class);
    private final AtomicInteger index;
    private final int threadPriority;

    WorkerPool(int minThreads, int maxThreads, long queueTime, int threadPriority) {
        super(minThreads, maxThreads, 60L, TimeUnit.SECONDS, new WaitingSynchronousQueue(queueTime));
        this.setThreadFactory(this);
        this.index = new AtomicInteger();
        this.threadPriority = threadPriority;
    }

    void setQueueTime(long queueTime) {
        ((WaitingSynchronousQueue)this.getQueue()).setQueueTime(queueTime);
    }

    void gracefulShutdown(long timeout) {
        this.shutdown();
        try {
            this.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.shutdownNow();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, "NIO Worker #" + this.index.incrementAndGet());
        thread.setUncaughtExceptionHandler(this);
        thread.setPriority(this.threadPriority);
        return thread;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        log.error((Object)("Uncaught exception in " + t), e);
    }

    private static final class WaitingSynchronousQueue
    extends SynchronousQueue<Runnable> {
        volatile long queueTime;

        WaitingSynchronousQueue(long queueTime) {
            this.setQueueTime(queueTime);
        }

        void setQueueTime(long queueTime) {
            if (queueTime > 1000L) {
                log.warn((Object)"Suspicious queueTime! Consider specifying time units (ms, s)");
                queueTime /= 1000L;
            }
            this.queueTime = queueTime;
        }

        @Override
        public boolean offer(Runnable r) {
            try {
                return super.offer(r, this.queueTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }
}

