/*
 * Decompiled with CFR 0.152.
 */
package one.nio.config;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import one.nio.config.Config;
import one.nio.config.Converter;
import one.nio.util.JavaInternals;

public class ConfigParser {
    private final StringTokenizer st;
    private final Map<String, Object> references;
    private String line;
    private int indent;

    private ConfigParser(String config) {
        this.st = new StringTokenizer(config, "\r\n");
        this.references = new HashMap<String, Object>();
        this.indent = -1;
    }

    public static <T> T parse(String config, Class<T> type) {
        ConfigParser parser = new ConfigParser(config);
        if (parser.nextLine() < 0) {
            throw new IllegalArgumentException("Unexpected end of input");
        }
        try {
            return (T)parser.parseValue(type, 0);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object parseValue(Type type, int level) throws ReflectiveOperationException {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls == String.class) {
                return this.tail();
            }
            if (cls.isPrimitive()) {
                return this.parsePrimitive(cls, this.tail());
            }
            if (cls.isArray()) {
                Object ref = this.parseReference();
                return ref != null ? ref : this.parseArray(cls.getComponentType(), level);
            }
            if (cls.isAnnotationPresent(Config.class)) {
                Object ref = this.parseReference();
                return ref != null ? ref : this.parseBean(cls, level);
            }
            Method method = JavaInternals.getMethod(cls, "valueOf", String.class);
            if (method != null && (method.getModifiers() & 8) != 0 && cls.isAssignableFrom(method.getReturnType())) {
                return method.invoke(null, this.tail());
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            if (ptype.getRawType() == List.class && ptype.getActualTypeArguments().length >= 1) {
                List<Object> ref = this.parseReference();
                return ref != null ? ref : this.parseList(ptype.getActualTypeArguments()[0], level);
            }
            if (ptype.getRawType() == Map.class && ptype.getActualTypeArguments().length >= 2) {
                Map<String, Object> ref = this.parseReference();
                return ref != null ? ref : this.parseMap(ptype.getActualTypeArguments()[1], level);
            }
        } else if (type instanceof GenericArrayType) {
            Object ref = this.parseReference();
            return ref != null ? ref : this.parseArray(((GenericArrayType)type).getGenericComponentType(), level);
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    private Object parseBean(Class<?> type, int minLevel) throws ReflectiveOperationException {
        Object obj = type.newInstance();
        this.registerReference(obj);
        this.fillBean(obj, minLevel);
        return obj;
    }

    private void fillBean(Object obj, int minLevel) throws ReflectiveOperationException {
        Map<String, Field> fields = ConfigParser.collectFields(obj.getClass());
        int level = this.nextLine();
        if (level >= minLevel) {
            do {
                int colon;
                if ((colon = this.line.indexOf(58, level)) < 0) {
                    throw new IllegalArgumentException("Field expected: " + this.line);
                }
                Field f = fields.get(this.line.substring(level, colon));
                if (f == null) {
                    throw new IllegalArgumentException("Unknown field: " + this.line);
                }
                this.skipSpaces(colon + 1);
                Converter converter = f.getAnnotation(Converter.class);
                Object value = converter != null ? this.convert(this.tail(), converter) : this.parseValue(f.getGenericType(), level + 1);
                f.set(obj, value);
            } while (this.nextLine() == level);
        }
    }

    private Object convert(String value, Converter converter) throws ReflectiveOperationException {
        Class<?> cls = converter.value();
        Method method = JavaInternals.getMethod(cls, converter.method(), String.class);
        if (method == null) {
            throw new IllegalArgumentException("Invalid converter class: " + cls.getName());
        }
        Object sender = (method.getModifiers() & 8) != 0 ? null : cls.newInstance();
        return method.invoke(sender, value);
    }

    private Object parseArray(Type elementType, int minLevel) throws ReflectiveOperationException {
        List<Object> list = this.parseList(elementType, minLevel);
        Class<?> cls = this.resolveArrayElementType(elementType);
        Object array = Array.newInstance(cls, list.size());
        this.changeReference(list, array);
        if (cls.isPrimitive()) {
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        return list.toArray((Object[])array);
    }

    private Class<?> resolveArrayElementType(Type elementType) {
        if (elementType instanceof Class) {
            return (Class)elementType;
        }
        if (elementType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)elementType).getRawType();
        }
        throw new IllegalArgumentException("Invalid array element type: " + elementType);
    }

    private void changeReference(List<?> list, Object array) {
        for (Map.Entry<String, Object> ref : this.references.entrySet()) {
            if (ref.getValue() != list) continue;
            ref.setValue(array);
            return;
        }
    }

    private List<Object> parseList(Type elementType, int minLevel) throws ReflectiveOperationException {
        ArrayList<Object> list = new ArrayList<Object>();
        this.registerReference(list);
        if (this.hasTail()) {
            Class cls;
            if (elementType instanceof Class && ((cls = (Class)elementType) == String.class || cls.isPrimitive())) {
                for (String element : this.tail().split(",")) {
                    list.add(this.parsePrimitive(cls, element.trim()));
                }
                return list;
            }
            throw new IllegalArgumentException("Array is expected");
        }
        int level = this.nextLine();
        if (level >= minLevel && this.line.charAt(level) == '-') {
            do {
                this.skipSpaces(level + 1);
                Object value = this.parseValue(elementType, level + 1);
                list.add(value);
            } while (this.nextLine() == level && this.line.charAt(level) == '-');
        }
        return list;
    }

    private Map<String, Object> parseMap(Type valueType, int minLevel) throws ReflectiveOperationException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.registerReference(map);
        int level = this.nextLine();
        if (level >= minLevel) {
            do {
                int colon;
                if ((colon = this.line.indexOf(58, level)) < 0) {
                    throw new IllegalArgumentException("Key expected: " + this.line);
                }
                String key = this.line.substring(level, colon);
                this.skipSpaces(colon + 1);
                Object value = this.parseValue(valueType, level + 1);
                map.put(key, value);
            } while (this.nextLine() == level);
        }
        return map;
    }

    private Object parsePrimitive(Class<?> type, String value) {
        if (type == Boolean.TYPE) {
            return "true".equalsIgnoreCase(value);
        }
        if (type == Byte.TYPE) {
            return Byte.decode(value);
        }
        if (type == Short.TYPE) {
            return Short.decode(value);
        }
        if (type == Integer.TYPE) {
            return Integer.decode(value);
        }
        if (type == Long.TYPE) {
            return Long.decode(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (type == String.class) {
            return value;
        }
        return null;
    }

    private void registerReference(Object ref) {
        if (this.hasTail() && this.line.charAt(this.indent) == '&') {
            Object prev = this.references.put(this.line.substring(this.indent + 1), ref);
            if (prev != null) {
                throw new IllegalArgumentException("Duplicate reference: " + this.line);
            }
            this.indent = -1;
        }
    }

    private Object parseReference() {
        if (this.hasTail() && this.line.charAt(this.indent) == '*') {
            Object ref = this.references.get(this.line.substring(this.indent + 1));
            if (ref == null) {
                throw new IllegalArgumentException("No such reference: " + this.line);
            }
            this.indent = -1;
            return ref;
        }
        return null;
    }

    private static Map<String, Field> collectFields(Class<?> cls) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        while (cls != Object.class) {
            for (Field f : cls.getDeclaredFields()) {
                if ((f.getModifiers() & 0x1088) != 0) continue;
                f.setAccessible(true);
                map.put(f.getName(), f);
            }
            cls = cls.getSuperclass();
        }
        return map;
    }

    private int nextLine() {
        if (this.indent >= 0) {
            return this.indent;
        }
        block0: while (this.st.hasMoreTokens()) {
            String s = this.st.nextToken();
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c == '#') continue block0;
                this.line = s;
                this.indent = i;
                return this.indent;
            }
        }
        this.indent = -1;
        return -1;
    }

    private void skipSpaces(int from) {
        int length = this.line.length();
        for (int i = from; i < length; ++i) {
            char c = this.line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (c == '#') break;
            this.indent = i;
            return;
        }
        this.indent = -1;
    }

    private String tail() {
        String result = this.indent >= 0 ? this.line.substring(this.indent) : "";
        this.indent = -1;
        return result;
    }

    private boolean hasTail() {
        return this.indent >= 0 && this.indent < this.line.length();
    }
}

