/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import one.nio.http.HttpServerConfig;
import one.nio.http.HttpSession;
import one.nio.http.Path;
import one.nio.http.Request;
import one.nio.http.RequestHandler;
import one.nio.http.Response;
import one.nio.http.VirtualHost;
import one.nio.http.gen.RequestHandlerGenerator;
import one.nio.net.Socket;
import one.nio.server.RejectedSessionException;
import one.nio.server.Server;

public class HttpServer
extends Server {
    private final Map<String, RequestHandler> defaultHandlers = new HashMap<String, RequestHandler>();
    private final Map<String, Map<String, RequestHandler>> handlersByAlias = new HashMap<String, Map<String, RequestHandler>>();
    private final Map<String, Map<String, RequestHandler>> handlersByHost = new HashMap<String, Map<String, RequestHandler>>();

    public HttpServer(HttpServerConfig config, Object ... routers) throws IOException {
        super(config);
        if (config.virtualHosts != null) {
            for (Map.Entry entry : config.virtualHosts.entrySet()) {
                HashMap handlers = new HashMap();
                this.handlersByAlias.put((String)entry.getKey(), handlers);
                for (String host : (String[])entry.getValue()) {
                    this.handlersByHost.put(host.toLowerCase(), handlers);
                }
            }
        }
        this.addRequestHandlers(this);
        for (Object router : routers) {
            this.addRequestHandlers(router);
        }
    }

    @Override
    public HttpSession createSession(Socket socket) throws RejectedSessionException {
        return new HttpSession(socket, this);
    }

    public void handleRequest(Request request, HttpSession session) throws IOException {
        RequestHandler handler = this.findHandlerByHost(request);
        if (handler == null) {
            handler = this.defaultHandlers.get(request.getPath());
        }
        if (handler != null) {
            handler.handleRequest(request, session);
        } else {
            this.handleDefault(request, session);
        }
    }

    public void handleDefault(Request request, HttpSession session) throws IOException {
        Response response = new Response("404 Not Found", Response.EMPTY);
        session.sendResponse(response);
    }

    private RequestHandler findHandlerByHost(Request request) {
        if (this.handlersByHost.isEmpty()) {
            return null;
        }
        String host = request.getHost();
        if (host == null) {
            return null;
        }
        Map<String, RequestHandler> handlers = this.handlersByHost.get(host.toLowerCase());
        if (handlers == null) {
            return null;
        }
        return handlers.get(request.getPath());
    }

    public void addRequestHandlers(Object router) {
        ArrayList supers = new ArrayList(4);
        for (Class<?> cls = router.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            supers.add(cls);
        }
        RequestHandlerGenerator generator = new RequestHandlerGenerator();
        int i = supers.size();
        while (--i >= 0) {
            Class cls = (Class)supers.get(i);
            VirtualHost virtualHost = cls.getAnnotation(VirtualHost.class);
            String[] aliases = virtualHost == null ? null : virtualHost.value();
            for (Method m : cls.getMethods()) {
                Path annotation = m.getAnnotation(Path.class);
                if (annotation == null) continue;
                RequestHandler requestHandler = generator.generateFor(m, router);
                for (String path : annotation.value()) {
                    if (!path.startsWith("/")) {
                        throw new IllegalArgumentException("Path '" + path + "' is not absolute");
                    }
                    if (aliases == null || aliases.length == 0) {
                        this.defaultHandlers.put(path, requestHandler);
                        continue;
                    }
                    for (String alias : aliases) {
                        Map<String, RequestHandler> handlers = this.handlersByAlias.get(alias);
                        if (handlers == null) continue;
                        handlers.put(path, requestHandler);
                    }
                }
            }
        }
    }
}

