/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import one.nio.util.ByteArrayBuilder;
import one.nio.util.URLEncoder;
import one.nio.util.Utf8;

public class Request {
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;
    public static final int METHOD_HEAD = 3;
    public static final int METHOD_OPTIONS = 4;
    public static final int METHOD_PUT = 5;
    public static final int METHOD_DELETE = 6;
    public static final int METHOD_TRACE = 7;
    public static final int METHOD_CONNECT = 8;
    public static final int METHOD_PATCH = 9;
    public static final byte[] VERB_GET = Utf8.toBytes("GET ");
    public static final byte[] VERB_POST = Utf8.toBytes("POST ");
    public static final byte[] VERB_HEAD = Utf8.toBytes("HEAD ");
    public static final byte[] VERB_OPTIONS = Utf8.toBytes("OPTIONS ");
    public static final byte[] VERB_PUT = Utf8.toBytes("PUT ");
    public static final byte[] VERB_DELETE = Utf8.toBytes("DELETE ");
    public static final byte[] VERB_TRACE = Utf8.toBytes("TRACE ");
    public static final byte[] VERB_CONNECT = Utf8.toBytes("CONNECT ");
    public static final byte[] VERB_PATCH = Utf8.toBytes("PATCH ");
    static final byte[][] VERBS = new byte[][]{new byte[0], VERB_GET, VERB_POST, VERB_HEAD, VERB_OPTIONS, VERB_PUT, VERB_DELETE, VERB_TRACE, VERB_CONNECT, VERB_PATCH};
    private static final byte[] HTTP10_HEADER = Utf8.toBytes(" HTTP/1.0\r\n");
    private static final byte[] HTTP11_HEADER = Utf8.toBytes(" HTTP/1.1\r\n");
    private static final int PROTOCOL_HEADER_LENGTH = 13;
    private int method;
    private String uri;
    private boolean http11;
    private int params;
    private int headerCount;
    private String[] headers;
    private byte[] body;

    public Request(int method, String uri, boolean http11) {
        this.method = method;
        this.uri = uri;
        this.http11 = http11;
        this.params = uri.indexOf(63);
        this.headerCount = 0;
        this.headers = new String[16];
    }

    public Request(Request prototype) {
        this.method = prototype.method;
        this.uri = prototype.uri;
        this.http11 = prototype.http11;
        this.params = prototype.params;
        this.headerCount = prototype.headerCount;
        this.headers = (String[])prototype.headers.clone();
        this.body = prototype.body;
    }

    public int getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isHttp11() {
        return this.http11;
    }

    public String getPath() {
        return this.params >= 0 ? this.uri.substring(0, this.params) : this.uri;
    }

    public String getQueryString() {
        return this.params >= 0 ? URLEncoder.decode(this.uri.substring(this.params + 1)) : null;
    }

    public String getParameter(String key) {
        int cur = this.params + 1;
        while (cur > 0) {
            int next = this.uri.indexOf(38, cur);
            if (this.uri.startsWith(key, cur)) {
                String rawValue = next > 0 ? this.uri.substring(cur, next) : this.uri.substring(cur += key.length());
                return URLEncoder.decode(rawValue);
            }
            cur = next + 1;
        }
        return null;
    }

    public Iterator<String> getParameters(final String key) {
        return new Iterator<String>(){
            int cur;
            {
                this.cur = this.findNext(Request.this.params + 1);
            }

            @Override
            public boolean hasNext() {
                return this.cur > 0;
            }

            @Override
            public String next() {
                int next = Request.this.uri.indexOf(38, this.cur);
                this.cur += key.length();
                String rawValue = next > 0 ? Request.this.uri.substring(this.cur, next) : Request.this.uri.substring(this.cur);
                this.cur = this.findNext(next + 1);
                return URLEncoder.decode(rawValue);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private int findNext(int cur) {
                while (cur > 0 && !Request.this.uri.startsWith(key, cur)) {
                    cur = Request.this.uri.indexOf(38, cur) + 1;
                }
                return cur;
            }
        };
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        return value != null ? value : defaultValue;
    }

    public String getRequiredParameter(String key) {
        String value = this.getParameter(key);
        if (value == null) {
            throw new NoSuchElementException("Missing required parameter: " + key);
        }
        return value;
    }

    public int getHeaderCount() {
        return this.headerCount;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        int keyLength = key.length();
        for (int i = 0; i < this.headerCount; ++i) {
            if (!this.headers[i].regionMatches(true, 0, key, 0, keyLength)) continue;
            return this.headers[i].substring(keyLength);
        }
        return null;
    }

    public String getHeader(String key, String defaultValue) {
        String value = this.getHeader(key);
        return value != null ? value : defaultValue;
    }

    public String getRequiredHeader(String key) {
        String value = this.getHeader(key);
        if (value == null) {
            throw new NoSuchElementException("Missing required header: " + key);
        }
        return value;
    }

    public void addHeader(String header) {
        if (this.headerCount >= this.headers.length) {
            this.headers = Arrays.copyOf(this.headers, this.headers.length + 8);
        }
        this.headers[this.headerCount++] = header;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBodyUtf8(String body) {
        this.body = body.getBytes(StandardCharsets.UTF_8);
    }

    public String getHost() {
        String host = this.getHeader("Host: ");
        if (host == null) {
            return null;
        }
        int hostEndIndex = host.indexOf(58);
        return hostEndIndex >= 0 ? host.substring(0, hostEndIndex) : host;
    }

    public byte[] toBytes() {
        int estimatedSize = VERBS[this.method].length + Utf8.length(this.uri) + 13 + this.headerCount * 2;
        for (int i = 0; i < this.headerCount; ++i) {
            estimatedSize += this.headers[i].length();
        }
        if (this.body != null) {
            estimatedSize += this.body.length;
        }
        ByteArrayBuilder builder = new ByteArrayBuilder(estimatedSize);
        builder.append(VERBS[this.method]).append(this.uri).append(this.http11 ? HTTP11_HEADER : HTTP10_HEADER);
        for (int i = 0; i < this.headerCount; ++i) {
            builder.append(this.headers[i]).append('\r').append('\n');
        }
        builder.append('\r').append('\n');
        if (this.body != null) {
            builder.append(this.body);
        }
        return builder.trim();
    }

    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }
}

