/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import one.nio.net.SelectableJavaSocket;
import one.nio.net.Selector;
import one.nio.net.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class JavaSelector
extends Selector {
    private static final Log log = LogFactory.getLog(JavaSelector.class);
    private final java.nio.channels.Selector impl = java.nio.channels.Selector.open();
    private final ConcurrentLinkedQueue<Session> pendingSessions = new ConcurrentLinkedQueue();
    private long lastWakeupTime;

    JavaSelector() throws IOException {
    }

    @Override
    public final int size() {
        return this.impl.keys().size();
    }

    @Override
    public boolean isOpen() {
        return this.impl.isOpen();
    }

    @Override
    public final void close() {
        try {
            this.impl.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void register(Session session) {
        session.selector = this;
        this.pendingSessions.add(session);
        this.impl.wakeup();
    }

    @Override
    public final void unregister(Session session) {
        SelectionKey key = ((SelectableJavaSocket)session.socket).getSelectableChannel().keyFor(this.impl);
        if (key != null) {
            key.cancel();
        }
        session.selector = null;
    }

    @Override
    public final void listen(Session session, int events) {
        ((SelectableJavaSocket)session.socket).getSelectableChannel().keyFor(this.impl).interestOps(events);
        this.impl.wakeup();
    }

    @Override
    public final Iterator<Session> iterator() {
        return JavaSelector.iteratorFor(this.impl.keys());
    }

    @Override
    public final Iterator<Session> select() {
        try {
            do {
                this.registerPendingSessions();
            } while (this.impl.select() == 0);
        }
        catch (ClosedSelectorException e) {
            return JavaSelector.iteratorFor(Collections.emptySet());
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected exception while selecting", (Throwable)e);
            return JavaSelector.iteratorFor(Collections.emptySet());
        }
        this.lastWakeupTime = System.nanoTime();
        Set<SelectionKey> selectedKeys = this.impl.selectedKeys();
        Iterator<Session> result = JavaSelector.iteratorFor(selectedKeys);
        selectedKeys.clear();
        return result;
    }

    @Override
    public long lastWakeupTime() {
        return this.lastWakeupTime;
    }

    private void registerPendingSessions() throws ClosedChannelException {
        Session session;
        while ((session = this.pendingSessions.poll()) != null) {
            try {
                ((SelectableJavaSocket)session.socket).getSelectableChannel().register(this.impl, session.eventsToListen, session);
            }
            catch (CancelledKeyException key) {
                log.warn((Object)("Cannot register session: " + session.toString()), (Throwable)key);
            }
        }
    }

    private static Iterator<Session> iteratorFor(Set<SelectionKey> keys) {
        final Session[] sessions = new Session[keys.size() + 1];
        int i = 0;
        for (SelectionKey key : keys) {
            if (!key.isValid()) continue;
            Session session = (Session)key.attachment();
            session.events = key.readyOps();
            sessions[i++] = session;
        }
        return new Iterator<Session>(){
            private int next = 0;

            @Override
            public final boolean hasNext() {
                return sessions[this.next] != null;
            }

            @Override
            public final Session next() {
                return sessions[this.next++];
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

