/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import one.nio.mem.DirectMemory;
import one.nio.net.SelectableJavaSocket;
import one.nio.net.Socket;
import one.nio.net.SocketClosedException;
import one.nio.net.SslContext;

final class JavaSocket
extends SelectableJavaSocket {
    SocketChannel ch;

    JavaSocket() throws IOException {
        this.ch = SocketChannel.open();
    }

    JavaSocket(SocketChannel ch) {
        this.ch = ch;
    }

    @Override
    public final boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public final void close() {
        try {
            this.ch.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final Socket accept() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void connect(InetAddress address, int port) throws IOException {
        this.ch.socket().connect(new InetSocketAddress(address, port), this.ch.socket().getSoTimeout());
    }

    @Override
    public final void bind(InetAddress address, int port, int backlog) throws IOException {
        this.ch.bind(new InetSocketAddress(address, port));
    }

    @Override
    public final void listen(int backlog) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int writeRaw(long buf, int count, int flags) throws IOException {
        return this.ch.write(DirectMemory.wrap(buf, count));
    }

    @Override
    public final int write(byte[] data, int offset, int count, int flags) throws IOException {
        return this.ch.write(ByteBuffer.wrap(data, offset, count));
    }

    @Override
    public final void writeFully(byte[] data, int offset, int count) throws IOException {
        this.ch.write(ByteBuffer.wrap(data, offset, count));
    }

    @Override
    public int send(ByteBuffer data, int flags, InetAddress address, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int readRaw(long buf, int count, int flags) throws IOException {
        int result = this.ch.read(DirectMemory.wrap(buf, count));
        if (result < 0) {
            throw new SocketClosedException();
        }
        return result;
    }

    @Override
    public final int read(byte[] data, int offset, int count) throws IOException {
        int result = this.ch.read(ByteBuffer.wrap(data, offset, count));
        if (result < 0) {
            throw new SocketClosedException();
        }
        return result;
    }

    @Override
    public InetSocketAddress recv(ByteBuffer buffer, int flags) throws IOException {
        throw new SocketClosedException();
    }

    @Override
    public final void readFully(byte[] data, int offset, int count) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, count);
        while (buffer.hasRemaining()) {
            if (this.ch.read(buffer) >= 0) continue;
            throw new SocketClosedException();
        }
    }

    @Override
    public final long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        return file.getChannel().transferTo(offset, count, this.ch);
    }

    @Override
    public final void setBlocking(boolean blocking) {
        try {
            this.ch.configureBlocking(blocking);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void setTimeout(int timeout) {
        try {
            this.ch.socket().setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public final void setKeepAlive(boolean keepAlive) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)keepAlive);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void setNoDelay(boolean noDelay) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)noDelay);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void setTcpFastOpen(boolean tcpFastOpen) {
    }

    @Override
    public final void setDeferAccept(boolean deferAccept) {
    }

    @Override
    public final void setReuseAddr(boolean reuseAddr, boolean reusePort) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void setRecvBuffer(int recvBuf) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)recvBuf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void setSendBuffer(int sendBuf) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)sendBuf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void setTos(int tos) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)tos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final byte[] getOption(int level, int option) {
        return null;
    }

    @Override
    public final boolean setOption(int level, int option, byte[] value) {
        return false;
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        try {
            return (InetSocketAddress)this.ch.getLocalAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        try {
            return (InetSocketAddress)this.ch.getRemoteAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Socket ssl(SslContext context) {
        return this;
    }

    @Override
    public SslContext getSslContext() {
        return null;
    }

    @Override
    public SelectableChannel getSelectableChannel() {
        return this.ch;
    }
}

